package cn.sh1rocu.tacz.api.event;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_310;
import net.minecraft.class_9779;

@Environment(EnvType.CLIENT)
public class RenderTickEvent extends BaseEvent {
    private final class_310 client;
    public final Phase phase;
    private final class_9779.class_9781 timer;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public RenderTickEvent(class_310 client, Phase phase, class_9779.class_9781 timer) {
        this.client = client;
        this.phase = phase;
        this.timer = timer;
    }

    public class_310 getClient() {
        return client;
    }

    public class_9779.class_9781 getTimer() {
        return timer;
    }

    public interface Callback {
        void post(RenderTickEvent event);
    }

    public enum Phase {
        START, END;
    }
}