package cn.sh1rocu.tacz.api.event;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_757;

@Environment(EnvType.CLIENT)
public abstract class ViewportEvent extends BaseEvent {
    private final class_757 renderer;
    private final class_4184 camera;
    private final double partialTick;

    public ViewportEvent(class_757 renderer, class_4184 camera, double partialTick) {
        this.renderer = renderer;
        this.camera = camera;
        this.partialTick = partialTick;
    }

    public static final Event<FovCallback> FOV = EventFactory.createArrayBacked(FovCallback.class, callbacks -> event -> {
        for (FovCallback callback : callbacks) callback.post(event);
    });

    public static final Event<CameraCallback> CAMERA = EventFactory.createArrayBacked(CameraCallback.class, callbacks -> event -> {
        for (CameraCallback post : callbacks) post.post(event);
    });

    public interface FovCallback {
        void post(ComputeFov event);
    }

    public interface CameraCallback {
        void post(ComputeCameraAngles event);
    }

    public class_757 getRenderer() {
        return this.renderer;
    }

    public class_4184 getCamera() {
        return this.camera;
    }

    public double getPartialTick() {
        return this.partialTick;
    }

    public static class ComputeFov extends ViewportEvent {
        private final boolean usedConfiguredFov;
        private double fov;

        public ComputeFov(class_757 renderer, class_4184 camera, double renderPartialTicks, double fov, boolean usedConfiguredFov) {
            super(renderer, camera, renderPartialTicks);
            this.usedConfiguredFov = usedConfiguredFov;
            this.setFOV(fov);
        }

        public double getFOV() {
            return this.fov;
        }

        public void setFOV(double fov) {
            this.fov = fov;
        }

        public boolean usedConfiguredFov() {
            return this.usedConfiguredFov;
        }
    }

    public static class ComputeCameraAngles extends ViewportEvent {
        private float yaw;
        private float pitch;
        private float roll;

        public ComputeCameraAngles(class_4184 camera, double renderPartialTicks, float yaw, float pitch, float roll) {
            super(class_310.method_1551().field_1773, camera, renderPartialTicks);
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setRoll(roll);
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }
}
