package com.tacz.guns.api.client.animation;

import com.tacz.guns.client.sound.SoundPlayManager;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ObjectAnimationSoundChannel {
    public AnimationSoundChannelContent content;

    public ObjectAnimationSoundChannel() {
    }

    public ObjectAnimationSoundChannel(AnimationSoundChannelContent content) {
        this.content = content;
    }

    /**
     * 播放区间内的所有声音。时间区间左开右闭
     */
    public void playSound(double fromTimeS, double toTimeS, class_1297 entity, int distance, float volume, float pitch) {
        if (content == null) {
            return;
        }
        if (fromTimeS == toTimeS) {
            return;
        }
        if (fromTimeS > toTimeS && fromTimeS <= getEndTimeS()) {
            playSound(0, toTimeS, entity, distance, volume, pitch);
            toTimeS = getEndTimeS();
        }
        int to = computeIndex(toTimeS, false);
        int from = computeIndex(fromTimeS, true);
        float mixVolume = volume;
        // 根据实体位置计算音量
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            mixVolume = mixVolume * (1.0F - Math.min(1.0F, (float) Math.sqrt(player.method_5707(entity.method_30950(0))) / distance));
            mixVolume *= mixVolume;
        }
        for (int i = from + 1; i <= to; i++) {
            class_2960 name = content.keyframeSoundName[i];
            SoundPlayManager.playClientSound(entity, name, mixVolume, pitch, distance);
        }
    }

    public double getEndTimeS() {
        return content.keyframeTimeS[content.keyframeTimeS.length - 1];
    }

    private int computeIndex(double timeS, boolean open) {
        int index = Arrays.binarySearch(content.keyframeTimeS, timeS);
        if (index >= 0) {
            return open ? index - 1 : index;
        }
        return -index - 2;
    }
}
