package com.tacz.guns.api.event.server;

import cn.sh1rocu.tacz.api.event.BaseEvent;
import cn.sh1rocu.tacz.api.event.ICancellableEvent;
import com.tacz.guns.api.event.common.KubeJSGunEventPoster;
import com.tacz.guns.entity.EntityKineticBullet;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

/**
 * 子弹击中方块时触发的事件，目前仅在服务端触发
 */
public class AmmoHitBlockEvent extends BaseEvent implements KubeJSGunEventPoster<AmmoHitBlockEvent>, ICancellableEvent {
    private final class_1937 level;
    private final class_3965 hitResult;
    private final class_2680 state;
    private final EntityKineticBullet ammo;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback e : callbacks) e.post(event);
    });

    public interface Callback {
        void post(AmmoHitBlockEvent event);
    }

    public AmmoHitBlockEvent(class_1937 level, class_3965 hitResult, class_2680 state, EntityKineticBullet ammo) {
        this.level = level;
        this.hitResult = hitResult;
        this.state = state;
        this.ammo = ammo;
        postServerEventToKubeJS(this);
    }

    public class_1937 getLevel() {
        return level;
    }

    public class_3965 getHitResult() {
        return hitResult;
    }

    public class_2680 getState() {
        return state;
    }

    public EntityKineticBullet getAmmo() {
        return ammo;
    }
}
