package com.tacz.guns.block;

import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.nbt.BlockItemDataAccessor;
import com.tacz.guns.block.entity.GunSmithTableBlockEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGunSmithTableBlock extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;

    public AbstractGunSmithTableBlock() {
        super(class_2251.method_9637().method_9626(class_2498.field_11547).method_9629(2.0F, 3.0F).method_22488().method_50012(class_3619.field_15971));
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    protected class_1269 method_55766(class_2680 pState, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (level.field_9236) {
            return class_1269.field_5812;
        } else {
            class_2586 blockEntity = level.method_8321(getRootPos(pos, pState));
            if (blockEntity instanceof GunSmithTableBlockEntity gunSmithTable && player instanceof class_3222 serverPlayer) {
                serverPlayer.method_17355(gunSmithTable);
            }
            return class_1269.field_21466;
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 blockState) {
        return new GunSmithTableBlockEntity(pos, blockState);
    }

    @Override
    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11456;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (!world.field_9236) {
            if (stack.method_7909() instanceof BlockItemDataAccessor accessor) {
                class_2960 id = accessor.getBlockId(stack);
                class_2586 blockentity = world.method_8321(pos);
                if (blockentity instanceof GunSmithTableBlockEntity e) {
                    e.setId(id);
                }
            }
        }
    }

    @Override
    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        class_2338 blockPos = getRootPos(pos, state);
        class_2586 blockentity = level.method_8321(blockPos);
        if (blockentity instanceof GunSmithTableBlockEntity e) {
            if (e.getId() != null) {
                return BlockItemBuilder.create(this).setId(e.getId()).build();
            }
            return new class_1799(this);
        }
        return super.method_9574(level, pos, state);
    }

    public abstract boolean isRoot(class_2680 blockState);

    public float parseRotation(class_2350 direction) {
        return 90.0F * (3 - direction.method_10161()) - 90;
    }

    public abstract class_2338 getRootPos(class_2338 pos, class_2680 blockState);
}
