package com.tacz.guns.block;

import cn.sh1rocu.tacz.api.extension.IBlockExtension;
import com.mojang.serialization.MapCodec;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.block.entity.StatueBlockEntity;
import com.tacz.guns.init.ModBlocks;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.Nullable;

public class StatueBlock extends class_2237 implements IBlockExtension {
    public static final MapCodec<StatueBlock> CODEC = method_54094((properties) -> new StatueBlock());
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2753 FACING = class_2741.field_12481;

    public StatueBlock() {
        super(class_2251.method_9637().method_9626(class_2498.field_11544).method_9629(2.0F, 3.0F).method_22488().method_50012(class_3619.field_15971));
        this.method_9590(this.field_10647.method_11664()
                .method_11657(HALF, class_2756.field_12607)
                .method_11657(FACING, class_2350.field_11043)
        );
    }

    @Override
    protected MapCodec<StatueBlock> method_53969() {
        return field_46280;
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return state.method_11654(HALF).equals(class_2756.field_12607) && level.method_8608() ? method_31618(blockEntityType, ModBlocks.STATUE_BE, StatueBlockEntity::clientTick) : null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(HALF, FACING);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return pState.method_11654(HALF) == class_2756.field_12607 ? new StatueBlockEntity(pPos, pState) : null;
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 pState, class_1937 level, class_2338 pos, class_1657 player, class_1268 pHand, class_3965 pHit) {
        if (level.method_8608()) {
            return class_9062.field_47728;
        } else {
            if (pState.method_11654(HALF) == class_2756.field_12609) {
                pos = pos.method_10074();
            }

            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof StatueBlockEntity statueBlockEntity) {
                if (stack.method_7909() instanceof IGun) {
                    statueBlockEntity.setGun(stack);
                    stack.method_7934(1);
                    return class_9062.field_47728;
                }

                if (stack.method_7960()) {
                    statueBlockEntity.dropItem();
                    return class_9062.field_47728;
                }
            }
            return class_9062.field_47729;
        }
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042().method_10153();
        class_2338 clickedPos = context.method_8037();
        class_2338 above = clickedPos.method_10084();
        class_1937 level = context.method_8045();
        if (level.method_8320(above).method_26166(context) && level.method_8621().method_11952(above)) {
            return this.method_9564().method_11657(FACING, direction);
        }
        return null;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (!world.field_9236) {
            class_2338 above = pos.method_10084();
            world.method_8652(above, state.method_11657(HALF, class_2756.field_12609), class_2248.field_31036);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101(world, pos, class_2248.field_31036);
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        class_2756 half = state.method_11654(HALF);

        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            if (half.equals(class_2756.field_12607) && facing == class_2350.field_11036 || half.equals(class_2756.field_12609) && facing == class_2350.field_11033) {
                // 拆一半另外一半跟着没
                if (!facingState.method_27852(this)) {
                    return class_2246.field_10124.method_9564();
                }
            }
        }

        return state;
    }

    @Override
    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pMovedByPiston) {
        if (!pState.method_27852(pNewState.method_26204())) {
            class_2586 blockentity = pLevel.method_8321(pPos);
            if (blockentity instanceof StatueBlockEntity statueBlockEntity) {
                statueBlockEntity.dropItem();
            }
            super.method_9536(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    public void tacz$onBlockExploded(class_2680 state, class_1937 level, class_2338 pos, class_1927 explosion) {
        IBlockExtension.super.tacz$onBlockExploded(state, level, pos, explosion);
    }
}
