package com.tacz.guns.block.entity;

import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.class_1275;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

import static com.tacz.guns.block.TargetBlock.OUTPUT_POWER;
import static com.tacz.guns.block.TargetBlock.STAND;

public class TargetBlockEntity extends class_2586 implements class_1275 {
    public static final class_2591<TargetBlockEntity> TYPE = class_2591.class_2592.method_20528(TargetBlockEntity::new, ModBlocks.TARGET).method_11034(null);
    /**
     * 标靶复位时间，暂定为 5 秒
     */
    private static final int RESET_TIME = 5 * 20;
    private static final String OWNER_TAG = "Owner";
    private static final String CUSTOM_NAME_TAG = "CustomName";
    public float rot = 0;
    public float oRot = 0;
    private @Nullable class_9296 owner;
    private @Nullable class_2561 name;

    public TargetBlockEntity(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, TargetBlockEntity pBlockEntity) {
        pBlockEntity.oRot = pBlockEntity.rot;
        if (state.method_11654(STAND)) {
            pBlockEntity.rot = Math.max(pBlockEntity.rot - 18, 0);
        } else {
            pBlockEntity.rot = Math.min(pBlockEntity.rot + 45, 90);
        }
    }

    @Nullable
    public class_9296 getOwner() {
        return owner;
    }

    public void setOwner(@Nullable class_9296 owner) {
        this.owner = owner;
        if (this.owner != null) {
            this.owner.method_57507().thenAcceptAsync((profile) -> {
                this.owner = profile;
                this.refresh();
            }, class_2631.field_45147);
        }
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573(OWNER_TAG, class_2520.field_33260)) {
            this.owner = class_9334.field_49617.method_57875().parse(provider.method_57093(class_2509.field_11560), tag.method_10562(OWNER_TAG)).getOrThrow();
        }
        if (tag.method_10573(CUSTOM_NAME_TAG, class_2520.field_33258)) {
            this.name = class_2561.class_2562.method_10877(tag.method_10558(CUSTOM_NAME_TAG), provider);
        }
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        ;
        if (owner != null) {
            tag.method_10566(OWNER_TAG, class_9334.field_49617.method_57875().encodeStart(provider.method_57093(class_2509.field_11560), owner).getOrThrow());
        }
        if (this.name != null) {
            tag.method_10582(CUSTOM_NAME_TAG, class_2561.class_2562.method_10867(this.name, provider));
        }
    }

    @Override
    public class_2561 method_5477() {
        return this.name != null ? this.name : class_2561.method_43473();
    }

    @Nullable
    @Override
    public class_2561 method_5797() {
        return this.name;
    }

    public void setCustomName(class_2561 name) {
        this.name = name;
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return method_38244(provider);
    }

    public void refresh() {
        this.method_5431();
        if (field_11863 != null) {
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
        }
    }

    // TODO
//    @Override
//    @Environment(EnvType.CLIENT)
//    public AABB getRenderBoundingBox() {
//        return AABB.encapsulatingFullBlocks(worldPosition.offset(-2, 0, -2), worldPosition.offset(2, 2, 2));
//    }

    public void hit(class_1937 level, class_2680 state, class_3965 hit, boolean isUpperBlock) {
        if (this.field_11863 != null && state.method_11654(STAND)) {
            class_2338 blockPos = hit.method_17777();
            // 如果是击中上方，把状态移动到下方处理
            if (isUpperBlock) {
                blockPos = blockPos.method_10074();
                state = level.method_8320(blockPos);
            }
            int redstoneStrength = TargetBlock.getRedstoneStrength(hit, isUpperBlock);
            level.method_8652(blockPos, state.method_11657(STAND, false).method_11657(OUTPUT_POWER, redstoneStrength), class_2248.field_31036);
            level.method_39279(blockPos, state.method_26204(), RESET_TIME);
            // 原版的声音传播距离由 volume 决定
            // 当声音大于 1 时，距离为 = 16 * volume
            float volume = OtherConfig.TARGET_SOUND_DISTANCE.get() / 16.0f;
            volume = Math.max(volume, 0);
            level.method_8396(null, blockPos, ModSounds.TARGET_HIT, class_3419.field_15245, volume, this.field_11863.field_9229.method_43057() * 0.1F + 0.9F);
        }
    }
}
