package com.tacz.guns.client.animation.third;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.other.ThirdPersonManager;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_630;

public class InnerThirdPersonManager {
    public static void setRotationAnglesHead(class_1309 entityIn, class_630 rightArm, class_630 leftArm, class_630 body, class_630 head, float limbSwingAmount) {
        // 游戏暂停时不进行动画计算，否则会 StackOverflow
        if (class_310.method_1551().method_1493()) {
            return;
        }
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724 == entityIn) {
            if (class_310.method_1551().field_1690.method_31044().method_31034()) {
                PlayerAnimatorCompat.stopAllAnimation(entityIn, 0);
                return;
            }
        }
        if (entityIn instanceof IGunOperator operator) {
            class_1799 mainHandItem = entityIn.method_6047();
            IGun iGun = IGun.getIGunOrNull(mainHandItem);
            if (iGun == null) {
                PlayerAnimatorCompat.stopAllAnimation(entityIn);
                return;
            }
            // 睡觉、爬梯、游泳、鞘翅飞行不播放第三人称动画
            if (entityIn.method_18376() == class_4050.field_18078 || entityIn.method_6101() || entityIn.method_5681() || entityIn.method_18376() == class_4050.field_18077) {
                PlayerAnimatorCompat.stopAllAnimation(entityIn);
                return;
            }

            TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
                if (PlayerAnimatorCompat.hasPlayerAnimator3rd(entityIn, display)) {
                    PlayerAnimatorCompat.playAnimation(entityIn, display, limbSwingAmount);
                } else {
                    playVanillaAnimation(entityIn, rightArm, leftArm, body, head, operator, display);
                }
            });
        }
    }

    private static void playVanillaAnimation(class_1309 entityIn, class_630 rightArm, class_630 leftArm, class_630 body, class_630 head, IGunOperator operator, GunDisplayInstance display) {
        String animation = display.getThirdPersonAnimation();
        float aimingProgress = operator.getSynAimingProgress();
        if (aimingProgress <= 0) {
            ThirdPersonManager.getAnimation(animation).animateGunHold(entityIn, rightArm, leftArm, body, head);
        } else {
            ThirdPersonManager.getAnimation(animation).animateGunAim(entityIn, rightArm, leftArm, body, head, aimingProgress);
        }
    }
}
