package com.tacz.guns.compat.jei;

import com.tacz.guns.api.item.*;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class GunModSubtype {
    public static ISubtypeInterpreter<class_1799> getAmmoSubtype() {
        return new ISubtypeInterpreter<>() {
            @Override
            public @Nullable Object getSubtypeData(class_1799 stack, UidContext uidContext) {
                return getLegacyStringSubtypeInfo(stack, uidContext);
            }

            @Override
            public String getLegacyStringSubtypeInfo(class_1799 stack, UidContext uidContext) {
                if (stack.method_7909() instanceof IAmmo iAmmo) {
                    return iAmmo.getAmmoId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<class_1799> getGunSubtype() {
        return new ISubtypeInterpreter<>() {
            @Override
            public @Nullable Object getSubtypeData(class_1799 stack, UidContext uidContext) {
                return getLegacyStringSubtypeInfo(stack, uidContext);
            }

            @Override
            public String getLegacyStringSubtypeInfo(class_1799 stack, UidContext uidContext) {
                if (stack.method_7909() instanceof IGun iGun) {
                    return iGun.getGunId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<class_1799> getAttachmentSubtype() {
        return new ISubtypeInterpreter<>() {
            @Override
            public @Nullable Object getSubtypeData(class_1799 stack, UidContext uidContext) {
                return getLegacyStringSubtypeInfo(stack, uidContext);
            }

            @Override
            public String getLegacyStringSubtypeInfo(class_1799 stack, UidContext uidContext) {
                if (stack.method_7909() instanceof IAttachment iAttachment) {
                    return iAttachment.getAttachmentId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<class_1799> getTableSubType() {
        return new ISubtypeInterpreter<>() {
            @Override
            public @Nullable Object getSubtypeData(class_1799 stack, UidContext uidContext) {
                return getLegacyStringSubtypeInfo(stack, uidContext);
            }

            @Override
            public String getLegacyStringSubtypeInfo(class_1799 stack, UidContext uidContext) {
                if (stack.method_7909() instanceof IBlock iBlock) {
                    return iBlock.getBlockId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<class_1799> getAmmoBoxSubtype() {
        return new ISubtypeInterpreter<>() {
            @Override
            public @Nullable Object getSubtypeData(class_1799 stack, UidContext uidContext) {
                return getLegacyStringSubtypeInfo(stack, uidContext);
            }

            @Override
            public String getLegacyStringSubtypeInfo(class_1799 stack, UidContext uidContext) {
                if (stack.method_7909() instanceof IAmmoBox iAmmoBox) {
                    if (iAmmoBox.isAllTypeCreative(stack)) {
                        return "all_type_creative";
                    }
                    if (iAmmoBox.isCreative(stack)) {
                        return "creative";
                    }
                    return String.format("level_%d", iAmmoBox.getAmmoLevel(stack));
                }
                return "";
            }
        };
    }
}