package com.tacz.guns.entity;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.extension.IEntityPersistentData;
import cn.sh1rocu.tacz.util.forge.network.IEntityExtension;
import cn.sh1rocu.tacz.util.forge.network.IEntityWithComplexSpawn;
import com.google.common.collect.Lists;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.entity.KnockBackModifier;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.client.particle.AmmoParticleSpawner;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.init.ModDamageTypes;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import com.tacz.guns.network.message.event.ServerMessageGunKill;
import com.tacz.guns.particles.BulletHoleOption;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.*;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage.DistanceDamagePair;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import com.tacz.guns.util.EntityUtil;
import com.tacz.guns.util.ExplodeUtil;
import com.tacz.guns.util.TacHitResult;
import com.tacz.guns.util.block.BlockRayTrace;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;

import java.util.*;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4770;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9129;

import static com.tacz.guns.api.event.common.GunDamageSourcePart.ARMOR_PIERCING;
import static com.tacz.guns.api.event.common.GunDamageSourcePart.NON_ARMOR_PIERCING;

/**
 * 动能武器打出的子弹实体。
 */
public class EntityKineticBullet extends class_1676 implements IEntityWithComplexSpawn, IEntityExtension {
    public static final class_1299<EntityKineticBullet> TYPE = class_1299.class_1300
            .<EntityKineticBullet>method_5903(EntityKineticBullet::new, class_1311.field_17715)
            .method_5901().method_5904().method_19947()
            .method_17687(0.0625F, 0.0625F)
            .method_27299(5).method_27300(5)
            .alwaysUpdateVelocity(false).method_5905("bullet");
    public static final class_6862<class_1299<?>> USE_MAGIC_DAMAGE_ON = class_6862.method_40092(class_7924.field_41266, class_2960.method_60654("tacz:use_magic_damage_on"));
    public static final class_6862<class_1299<?>> USE_VOID_DAMAGE_ON = class_6862.method_40092(class_7924.field_41266, class_2960.method_60654("tacz:use_void_damage_on"));
    public static final class_6862<class_1299<?>> PRETEND_MELEE_DAMAGE_ON = class_6862.method_40092(class_7924.field_41266, class_2960.method_60654("tacz:pretend_melee_damage_on"));

    /**
     * 允许其他 mod 使用 persistent data（永久数据） 控制曳光弹的颜色和粗细。<p>
     * 使用永久数据的好处是即使以后本类大改，使用了这个功能的其他 mod 也不会崩溃。<p>
     * 下面两个字段是 persistent data 的 key。<p>
     * 这个字段的值的类型是 int[4]。<p>
     * <p>
     * 使用例：
     * <pre>{@code
     *     bullet.getPersistentData().putIntArray(TRACER_COLOR_OVERRIDER_KEY, new int[]{255, 255, 255, 255});
     * }</pre>
     */
    public static final String TRACER_COLOR_OVERRIDER_KEY = GunMod.MOD_ID + ":tracer_override";

    /**
     * 这个字段的值的类型是 float。
     * 1 表示默认大小，0 表示 0 倍率粗细（不显示了）
     */
    public static final String TRACER_SIZE_OVERRIDER_KEY = GunMod.MOD_ID + ":tracer_size";

    private class_2960 ammoId = DefaultAssets.EMPTY_AMMO_ID;
    private int life = 200;
    private float speed = 1;
    private float gravity = 0;
    private float friction = 0.01F;
    private LinkedList<DistanceDamagePair> damageAmount = Lists.newLinkedList();
    private float distanceAmount = 0;
    private float knockback = 0;
    private boolean explosion = false;
    private boolean igniteEntity = false;
    private boolean igniteBlock = false;
    private int igniteEntityTime = 2;
    private float explosionDamage = 3;
    private float explosionRadius = 3;
    private int explosionDelayCount = Integer.MAX_VALUE;
    private boolean explosionKnockback = false;
    private boolean explosionDestroyBlock = false;
    private float damageModifier = 1;
    // 穿透数
    private int pierce = 1;
    // 初始位置
    private class_243 startPos;
    // 曳光弹
    private boolean isTracerAmmo;
    // 以下几个是只对客户端有用的曳光弹数据
    private float cameraXRot;
    private float cameraYRot;
    private Vector3f firstPersonRenderOffset;
    // 发射的枪械 ID
    private class_2960 gunId = DefaultAssets.EMPTY_GUN_ID;
    // 枪械display ID
    private class_2960 gunDisplayId = DefaultAssets.DEFAULT_GUN_DISPLAY_ID;
    private float armorIgnore;
    private float headShot;

    public EntityKineticBullet(class_1299<? extends class_1676> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public EntityKineticBullet(class_1299<? extends class_1676> type, double x, double y, double z, class_1937 worldIn) {
        this(type, worldIn);
        this.method_5814(x, y, z);
    }

    public EntityKineticBullet(class_1937 worldIn, class_1309 throwerIn, class_1799 gunItem, class_2960 ammoId, class_2960 gunId,
                               class_2960 gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, gunDisplayId, isTracerAmmo, gunData, bulletData);
    }

    public EntityKineticBullet(class_1937 worldIn, class_1309 throwerIn, class_1799 gunItem, class_2960 ammoId, class_2960 gunId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID, isTracerAmmo, gunData, bulletData);
    }

    protected EntityKineticBullet(class_1299<? extends class_1676> type, class_1937 worldIn, class_1309 throwerIn, class_1799 gunItem,
                                  class_2960 ammoId, class_2960 gunId, class_2960 gunDisplayId,
                                  boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(type, throwerIn.method_23317(), throwerIn.method_23320() - (double) 0.1F, throwerIn.method_23321(), worldIn);
        this.method_7432(throwerIn);
        AttachmentCacheProperty cacheProperty = Objects.requireNonNull(IGunOperator.fromLivingEntity(throwerIn).getCacheProperty());
        this.armorIgnore = class_3532.method_15363(cacheProperty.getCache(ArmorIgnoreModifier.ID), 0f, 1f);
        this.headShot = Math.max(cacheProperty.getCache(HeadShotModifier.ID), 0f);
        this.knockback = Math.max(cacheProperty.getCache(KnockbackModifier.ID), 0f);
        this.ammoId = ammoId;
        this.life = class_3532.method_15340((int) (bulletData.getLifeSecond() * 20), 1, Integer.MAX_VALUE);
        // 限制最大弹速为 600 m / s，以减轻计算负担
        this.speed = class_3532.method_15363(cacheProperty.<Float>getCache(AmmoSpeedModifier.ID) / 20f, 0f, 30f);
        this.gravity = class_3532.method_15363(bulletData.getGravity(), 0f, Float.MAX_VALUE);
        this.friction = class_3532.method_15363(bulletData.getFriction(), 0f, Float.MAX_VALUE);
        Ignite ignite = cacheProperty.getCache(IgniteModifier.ID);
        this.igniteEntity = bulletData.getIgnite().isIgniteEntity() || ignite.isIgniteEntity();
        this.igniteEntityTime = Math.max(bulletData.getIgniteEntityTime(), 0);
        this.igniteBlock = bulletData.getIgnite().isIgniteBlock() || ignite.isIgniteBlock();
        this.damageAmount = cacheProperty.getCache(DamageModifier.ID);
        this.distanceAmount = cacheProperty.getCache(EffectiveRangeModifier.ID);
        // 霰弹情况，每个伤害要扣去
        if (bulletData.getBulletAmount() > 1) {
            this.damageModifier = 1f / bulletData.getBulletAmount();
        }
        this.pierce = class_3532.method_15340(cacheProperty.getCache(PierceModifier.ID), 1, Integer.MAX_VALUE);
        ExplosionData explosionData = cacheProperty.getCache(ExplosionModifier.ID);
        if (explosionData != null) {
            this.explosion = explosionData.isExplode();
            this.explosionDamage = (float) class_3532.method_15350(explosionData.getDamage() * SyncConfig.DAMAGE_BASE_MULTIPLIER.get(), 0, Float.MAX_VALUE);
            this.explosionRadius = class_3532.method_15363(explosionData.getRadius(), 0, Float.MAX_VALUE);
            this.explosionKnockback = explosionData.isKnockback();
            // 防止越界，提前判定
            int delayTickCount = (int) (explosionData.getDelay() * 20);
            if (delayTickCount < 0) {
                delayTickCount = Integer.MAX_VALUE;
            }
            this.explosionDestroyBlock = explosionData.isDestroyBlock() && AmmoConfig.EXPLOSIVE_AMMO_DESTROYS_BLOCK.get();
            this.explosionDelayCount = Math.max(delayTickCount, 1);
        }
        // 子弹初始位置重置
        double posX = throwerIn.field_6038 + (throwerIn.method_23317() - throwerIn.field_6038) / 2.0;
        double posY = throwerIn.field_5971 + (throwerIn.method_23318() - throwerIn.field_5971) / 2.0 + throwerIn.method_5751();
        double posZ = throwerIn.field_5989 + (throwerIn.method_23321() - throwerIn.field_5989) / 2.0;
        this.method_5814(posX, posY, posZ);
        this.startPos = this.method_19538();
        this.isTracerAmmo = isTracerAmmo;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    @Override
    protected void method_5693(class_2945.@NotNull class_9222 builder) {
    }

    @Override
    public void method_5773() {
        super.method_5773();
        // 调用 TaC 子弹服务器事件
        this.onBulletTick();
        // 粒子效果
        if (this.method_37908().field_9236) {
            AmmoParticleSpawner.addParticle(this);
        }
        // 子弹模型的旋转与抛物线
        class_243 movement = this.method_18798();
        double x = movement.field_1352;
        double y = movement.field_1351;
        double z = movement.field_1350;
        double distance = movement.method_37267();
        this.method_36456((float) Math.toDegrees(class_3532.method_15349(x, z)));
        this.method_36457((float) Math.toDegrees(class_3532.method_15349(y, distance)));
        // 子弹初始的朝向设置
        if (this.field_6004 == 0.0F && this.field_5982 == 0.0F) {
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        // 子弹运动时的旋转（不包含自转）
        this.method_36457(method_26960(this.field_6004, this.method_36455()));
        this.method_36456(method_26960(this.field_5982, this.method_36454()));
        // 子弹位置更新
        double nextPosX = this.method_23317() + x;
        double nextPosY = this.method_23318() + y;
        double nextPosZ = this.method_23321() + z;
        this.method_5814(nextPosX, nextPosY, nextPosZ);
        float friction = this.friction;
        float gravity = this.gravity;
        // 子弹入水后的调整
        if (this.method_5799()) {
            for (int i = 0; i < 4; i++) {
                this.method_37908().method_8406(class_2398.field_11247, nextPosX - x * 0.25F, nextPosY - y * 0.25F, nextPosZ - z * 0.25F, x, y, z);
            }
            // 在水中的阻力
            friction = 0.4F;
            gravity *= 0.6F;
        }
        // 重力与阻力更新速度状态
        this.method_18799(this.method_18798().method_1021(1 - friction));
        this.method_18799(this.method_18798().method_1031(0, -gravity, 0));
        // 子弹生命结束
        if (this.field_6012 >= this.life - 1) {
            this.method_31472();
        }
    }

    // 子弹的逻辑处理
    protected void onBulletTick() {
        // 服务器端子弹逻辑
        if (!this.method_37908().method_8608()) {
            // 延迟爆炸判定
            if (this.explosion) {
                if (this.explosionDelayCount > 0) {
                    this.explosionDelayCount--;
                } else {
                    ExplodeUtil.createExplosion(this.method_24921(), this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, this.method_19538());
                    // 爆炸直接结束不留弹孔，不处理之后的逻辑
                    this.method_31472();
                    return;
                }
            }
            // 子弹在 tick 起始的位置
            class_243 startVec = this.method_19538();
            // 子弹在 tick 结束的位置
            class_243 endVec = startVec.method_1019(this.method_18798());
            // 子弹的碰撞检测
            class_239 result = BlockRayTrace.rayTraceBlocks(this.method_37908(), new class_3959(startVec, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this));
            class_3965 resultB = (class_3965) result;
            if (resultB.method_17783() != class_239.class_240.field_1333) {
                // 子弹击中方块时，设置击中方块的位置为子弹的结束位置
                endVec = resultB.method_17784();
            }

            List<EntityResult> hitEntities = null;
            // 子弹的击中检测，穿透为 1 或者爆炸类弹药限制为一个实体穿透判定
            if (this.pierce <= 1 || this.explosion) {
                EntityResult entityResult = EntityUtil.findEntityOnPath(this, startVec, endVec);
                // 将单个命中是实体创建为单个内容的 list
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = EntityUtil.findEntitiesOnPath(this, startVec, endVec);
            }
            // 当子弹击中实体时，进行被命中的实体读取
            if (hitEntities != null && !hitEntities.isEmpty()) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                // 对被命中的实体进行排序，按照距离子弹发射位置的距离进行升序排序
                for (int i = 0; (i < this.pierce || i < 1) && i < (hitEntityResult.length - 1); i++) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; j++) {
                        if (hitEntityResult[j].hitVec.method_1022(startVec) < hitEntityResult[k].hitVec.method_1022(startVec)) {
                            k = j;
                        }
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new TacHitResult(entityResult);
                    this.onHitEntity((TacHitResult) result, startVec, endVec);
                    this.pierce--;
                    if (this.pierce < 1 || this.explosion) {
                        // 子弹已经穿透所有实体，结束子弹的飞行
                        this.method_31472();
                        return;
                    }
                }
            }
            this.onHitBlock(resultB, startVec, endVec);
        }
    }

    public void shoot(double pitch, double yaw, float pVelocity, Vector2d vector2d) {
        Vector3d left = new Vector3d(vector2d.x, vector2d.y, 8);

        left.rotateX(pitch * class_3532.field_29847);
        left.rotateY(-yaw * class_3532.field_29847);

        class_243 vec3 = new class_243(left.x, left.y, left.z).method_1029().method_1021(pVelocity);

        this.method_18800(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        double d0 = vec3.method_37267();
        this.method_36456((float) (class_3532.method_15349(vec3.field_1352, vec3.field_1350) * (double) (180F / (float) Math.PI)));
        this.method_36457((float) (class_3532.method_15349(vec3.field_1351, d0) * (double) (180F / (float) Math.PI)));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void shootFromRotation(class_1297 pShooter, float pX, float pY, float pZ, float pVelocity, Vector2d vector2d) {
        this.shoot(pX, pY, pVelocity, vector2d);
        class_243 vec3 = pShooter.method_18798();
        this.method_18799(this.method_18798().method_1031(vec3.field_1352, pShooter.method_24828() ? 0.0D : vec3.field_1351, vec3.field_1350));
    }

    public record MaybeMultipartEntity(
            class_1297 hitPart,
            class_1297 core
    ) {
        public static MaybeMultipartEntity of(class_1297 hitPart) {
            // TODO
            var core = /*(hitPart instanceof PartEntity<?> part)
                    ? part.getParent()
                    :*/ hitPart;
            return new MaybeMultipartEntity(hitPart, core);
        }
    }

    protected void onHitEntity(TacHitResult result, class_243 startVec, class_243 endVec) {
        if (result.method_17782() instanceof ITargetEntity targetEntity) {
            class_1282 source = this.method_48923().method_48811(this, this.method_24921());
            targetEntity.onProjectileHit(this, result, source, this.getDamage(result.method_17784()));
            // 打靶直接返回
            return;
        }
        // 获取Pre事件必要的信息
        class_1297 entity = result.method_17782();
        @Nullable class_1297 owner = this.method_24921();
        // 攻击者
        class_1309 attacker = owner instanceof class_1309 ? (class_1309) owner : null;
        var sources = createDamageSources(MaybeMultipartEntity.of(entity));
        boolean headshot = result.isHeadshot();
        float damage = this.getDamage(result.method_17784());
        float headShotMultiplier = Math.max(this.headShot, 0);
        // 发布Pre事件
        var preEvent = new EntityHurtByGunEvent.Pre(this, entity, attacker, this.gunId, this.gunDisplayId, damage, sources, headshot, headShotMultiplier, LogicalSide.SERVER);
        EntityHurtByGunEvent.PRE.invoker().post(preEvent);
        if (preEvent.isCanceled()) {
            return;
        }
        // 刷新由Pre事件修改后的参数
        entity = preEvent.getHurtEntity();
        // 受击目标
        var parts = MaybeMultipartEntity.of(entity);
        attacker = preEvent.getAttacker();
        var newGunId = preEvent.getGunId();
        damage = preEvent.getBaseAmount();
        sources = Pair.of(preEvent.getDamageSource(NON_ARMOR_PIERCING), preEvent.getDamageSource(ARMOR_PIERCING));
        headshot = preEvent.isHeadShot();
        headShotMultiplier = preEvent.getHeadshotMultiplier();
        if (entity == null) {
            return;
        }
        // 点燃
        if (this.igniteEntity && AmmoConfig.IGNITE_ENTITY.get()) {
            entity.method_20803(this.igniteEntityTime);
            // 给予粒子效果
            if (this.method_37908() instanceof class_3218 serverLevel) {
                serverLevel.method_14199(class_2398.field_11239, entity.method_23317(), entity.method_23318() + entity.method_5751(), entity.method_23321(), 1, 0, 0, 0, 0);
            }
        }
        // TODO 暴击判定（不是爆头）暴击判定内部逻辑，需要输出一个是否暴击的 flag
        if (headshot) {
            // 默认爆头伤害是 1x
            damage *= headShotMultiplier;
        }
        // 对 LivingEntity 进行击退强度的自定义
        if (parts.core() instanceof class_1309 livingCore) {
            // 取消击退效果，设定自己的击退强度
            KnockBackModifier modifier = KnockBackModifier.fromLivingEntity(livingCore);
            modifier.setKnockBackStrength(this.knockback);
            // 创建伤害
            tacAttackEntity(parts, damage, sources);
            // 恢复原位
            modifier.resetKnockBackStrength();
        } else {
            // 创建伤害
            tacAttackEntity(parts, damage, sources);
        }
        // 爆炸逻辑
        if (this.explosion) {
            // 取消无敌时间
            parts.core().field_6008 = 0;
            ExplodeUtil.createExplosion(this.method_24921(), this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, result.method_17784());
        }
        // 只对 LivingEntity 执行击杀判定
        if (parts.core() instanceof class_1309 livingCore) {
            // 事件同步，从服务端到客户端
            if (!method_37908().field_9236) {
                int attackerId = attacker == null ? 0 : attacker.method_5628();
                // 如果生物死了
                if (livingCore.method_29504()) {
                    EntityKillByGunEvent killByGunEvent = new EntityKillByGunEvent(this, livingCore, attacker, newGunId, gunDisplayId, damage, sources, headshot, headShotMultiplier, LogicalSide.SERVER);
                    EntityKillByGunEvent.CALLBACK.invoker().post(killByGunEvent);
                    NetworkHandler.sendToDimension(new ServerMessageGunKill(method_5628(), livingCore.method_5628(), attackerId, newGunId, gunDisplayId, damage, headshot, headShotMultiplier), livingCore);
                } else {
                    EntityHurtByGunEvent.Post hurtByGunEvent = new EntityHurtByGunEvent.Post(this, livingCore, attacker, newGunId, gunDisplayId, damage, sources, headshot, headShotMultiplier, LogicalSide.SERVER);
                    EntityHurtByGunEvent.POST.invoker().post(hurtByGunEvent);
                    NetworkHandler.sendToDimension(new ServerMessageGunHurt(method_5628(), livingCore.method_5628(), attackerId, newGunId, gunDisplayId, damage, headshot, headShotMultiplier), livingCore);
                }
            }
        }
    }

    protected void onHitBlock(class_3965 result, class_243 startVec, class_243 endVec) {
        if (result.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_2338 pos = result.method_17777();
        class_243 hitVec = result.method_17784();
        // 触发事件
        // 提前触发事件以让事件可以取消原版的命中行为（例如敲钟，打倒靶子等）
        AmmoHitBlockEvent ammoHitBlockEvent = new AmmoHitBlockEvent(this.method_37908(), result, this.method_37908().method_8320(pos), this);
        AmmoHitBlockEvent.CALLBACK.invoker().post(ammoHitBlockEvent);
        if (ammoHitBlockEvent.isCanceled()) {
            return;
        }
        super.method_24920(result);
        // 爆炸
        if (this.explosion) {
            ExplodeUtil.createExplosion(this.method_24921(), this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, hitVec);
            // 爆炸直接结束不留弹孔，不处理之后的逻辑
            this.method_31472();
            return;
        }
        // 弹孔与点燃特效
        if (this.method_37908() instanceof class_3218 serverLevel) {
            BulletHoleOption bulletHoleOption = new BulletHoleOption(result.method_17780(), result.method_17777(), this.ammoId.toString(), this.gunId.toString(), this.gunDisplayId.toString());
            serverLevel.method_14199(bulletHoleOption, hitVec.field_1352, hitVec.field_1351, hitVec.field_1350, 1, 0, 0, 0, 0);
            if (this.igniteBlock) {
                serverLevel.method_14199(class_2398.field_11239, hitVec.field_1352, hitVec.field_1351, hitVec.field_1350, 1, 0, 0, 0, 0);
            }
        }
        if (this.igniteBlock && AmmoConfig.IGNITE_BLOCK.get()) {
            class_2338 offsetPos = pos.method_10093(result.method_17780());
            if (class_4770.method_30032(this.method_37908(), offsetPos, result.method_17780())) {
                class_2680 fireState = class_4770.method_24416(this.method_37908(), offsetPos);
                this.method_37908().method_8652(offsetPos, fireState, class_2248.field_31022);
                ((class_3218) this.method_37908()).method_14199(class_2398.field_11239, hitVec.field_1352 - 1.0 + this.field_5974.method_43058() * 2.0, hitVec.field_1351, hitVec.field_1350 - 1.0 + this.field_5974.method_43058() * 2.0, 4, 0, 0, 0, 0);
            }
        }
        this.method_31472();
    }

    // 根据距离进行伤害衰减设计
    public float getDamage(class_243 hitVec) {
        // 遍历进行判断
        double playerDistance = hitVec.method_1022(this.startPos);
        for (DistanceDamagePair pair : this.damageAmount) {
            float effectiveDistance = this.damageAmount.get(0).getDistance() == pair.getDistance() ? this.distanceAmount : pair.getDistance();
            if (playerDistance < effectiveDistance) {
                float damage = pair.getDamage();
                return Math.max(damage * this.damageModifier, 0F);
            }
        }
        // 如果忘记写最大值，那我就直接认为你伤害为 0
        return 0;
    }

    /**
     * @return Pair<非穿甲伤害源 ， 穿甲伤害源>
     */
    private Pair<class_1282, class_1282> createDamageSources(MaybeMultipartEntity parts) {
        class_1282 source1, source2;
        var hitPartType = parts.hitPart().method_5864();
        var directCause = hitPartType.method_20210(PRETEND_MELEE_DAMAGE_ON) ? this.method_24921() : this;
        // 给末影人造成伤害
        if (hitPartType.method_20210(USE_MAGIC_DAMAGE_ON)) {
            source1 = source2 = this.method_48923().method_48815(this, method_24921());
        } else if (hitPartType.method_20210(USE_VOID_DAMAGE_ON)) {
            source1 = ModDamageTypes.Sources.bulletVoid(this.method_56673(), directCause, this.method_24921(), false);
            source2 = ModDamageTypes.Sources.bulletVoid(this.method_56673(), directCause, this.method_24921(), true);
        } else {
            source1 = ModDamageTypes.Sources.bullet(this.method_56673(), directCause, this.method_24921(), false);
            source2 = ModDamageTypes.Sources.bullet(this.method_56673(), directCause, this.method_24921(), true);
        }
        return Pair.of(source1, source2);
    }

    private void tacAttackEntity(MaybeMultipartEntity parts, float damage, Pair<class_1282, class_1282> sources) {
        var source1 = sources.getLeft();
        var source2 = sources.getRight();
        // 穿甲伤害和普通伤害的比例计算
        float armorDamagePercent = class_3532.method_15363(this.armorIgnore, 0.0F, 1.0F);
        float normalDamagePercent = 1 - armorDamagePercent;
        // 取消无敌时间
        parts.core().field_6008 = 0;
        // 普通伤害
        parts.hitPart().method_5643(source1, damage * normalDamagePercent);
        // 取消无敌时间
        parts.core().field_6008 = 0;
        // 穿甲伤害
        parts.hitPart().method_5643(source2, damage * armorDamagePercent);
    }

    @Override
    public void writeSpawnData(class_9129 buffer) {
        buffer.method_52941(method_36455());
        buffer.method_52941(method_36454());
        buffer.method_52940(method_18798().field_1352);
        buffer.method_52940(method_18798().field_1351);
        buffer.method_52940(method_18798().field_1350);
        class_1297 entity = method_24921();
        buffer.method_53002(entity != null ? entity.method_5628() : 0);
        buffer.method_10812(ammoId);
        buffer.method_52941(this.gravity);
        buffer.method_52964(this.explosion);
        buffer.method_52964(this.igniteEntity);
        buffer.method_52964(this.igniteBlock);
        buffer.method_52941(this.explosionRadius);
        buffer.method_52941(this.explosionDamage);
        buffer.method_53002(this.life);
        buffer.method_52941(this.speed);
        buffer.method_52941(this.friction);
        buffer.method_53002(this.pierce);
        buffer.method_52964(this.isTracerAmmo);
        buffer.method_10812(this.gunId);
        buffer.method_10812(this.gunDisplayId);
    }

    @Override
    public void readSpawnData(class_9129 additionalData) {
        method_36457(additionalData.readFloat());
        method_36456(additionalData.readFloat());
        method_18800(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        class_1297 entity = this.method_37908().method_8469(additionalData.readInt());
        if (entity != null) {
            this.method_7432(entity);
        }
        this.ammoId = additionalData.method_10810();
        this.gravity = additionalData.readFloat();
        this.explosion = additionalData.readBoolean();
        this.igniteEntity = additionalData.readBoolean();
        this.igniteBlock = additionalData.readBoolean();
        this.explosionRadius = additionalData.readFloat();
        this.explosionDamage = additionalData.readFloat();
        this.life = additionalData.readInt();
        this.speed = additionalData.readFloat();
        this.friction = additionalData.readFloat();
        this.pierce = additionalData.readInt();
        this.isTracerAmmo = additionalData.readBoolean();
        this.gunId = additionalData.method_10810();
        this.gunDisplayId = additionalData.method_10810();
    }

    public class_2960 getAmmoId() {
        return ammoId;
    }

    public class_2960 getGunId() {
        return gunId;
    }

    public class_2960 getGunDisplayId() {
        return gunDisplayId;
    }

    public boolean isTracerAmmo() {
        return isTracerAmmo;
    }

    public class_5819 method_59922() {
        return this.field_5974;
    }

    public float getCameraYRot() {
        return cameraYRot;
    }

    public void setCameraYRot(float cameraYRot) {
        this.cameraYRot = cameraYRot;
    }

    public float getCameraXRot() {
        return cameraXRot;
    }

    public void setCameraXRot(float cameraXRot) {
        this.cameraXRot = cameraXRot;
    }

    public Vector3f getFirstPersonRenderOffset() {
        return firstPersonRenderOffset;
    }

    public void setFirstPersonRenderOffset(Vector3f originRenderOffset) {
        this.firstPersonRenderOffset = originRenderOffset;
    }

    public Optional<float[]> getTracerColorOverride() {
        var pd = ((IEntityPersistentData) this).tacz$getPersistentData();
        if (!pd.method_10573(TRACER_COLOR_OVERRIDER_KEY, class_2520.field_33261)) {
            return Optional.empty();
        } else {
            var ints = pd.method_10561(TRACER_COLOR_OVERRIDER_KEY);
            // 请避免使用 1 或者 2 个值的数组。
            // 此处 1~2 个值的分支仅为优雅地处理异常情况来代替崩溃所作的措施 :(
            switch (ints.length) {
                case 0:
                    return Optional.empty();
                case 1: {
                    var albedo = ints[0] / 255F;
                    return Optional.of(new float[]{albedo, albedo, albedo, 1});
                }
                case 2: {
                    var albedo = ints[0] / 255F;
                    var alpha = ints[1] / 255F;
                    return Optional.of(new float[]{albedo, albedo, albedo, alpha});
                }
                case 3: {
                    var r = ints[0] / 255F;
                    var g = ints[1] / 255F;
                    var b = ints[2] / 255F;
                    return Optional.of(new float[]{r, g, b, 1});
                }
                default: {
                    var r = ints[0] / 255F;
                    var g = ints[1] / 255F;
                    var b = ints[2] / 255F;
                    var a = ints[3] / 255F;
                    return Optional.of(new float[]{r, g, b, a});
                }
            }
        }
    }

    public float getTracerSizeOverride() {
        var pd = ((IEntityPersistentData) this).tacz$getPersistentData();
        return pd.method_10573(TRACER_SIZE_OVERRIDER_KEY, class_2520.field_33263) ? pd.method_10583(TRACER_SIZE_OVERRIDER_KEY) : 1;
    }

    @Override
    public boolean method_34714(@Nullable class_1297 entity) {
        if (entity == null) {
            return false;
        }
        return super.method_34714(entity);
    }

    public static class EntityResult {
        private final class_1297 entity;
        private final class_243 hitVec;
        private final boolean headshot;

        public EntityResult(class_1297 entity, class_243 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        // 子弹命中的实体
        public class_1297 getEntity() {
            return this.entity;
        }

        // 子弹命中的位置
        public class_243 getHitPos() {
            return this.hitVec;
        }

        // 是否为爆头
        public boolean isHeadshot() {
            return this.headshot;
        }
    }
}
