package com.tacz.guns.util.block;

import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.init.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public final class BlockRayTrace {
    private static final Predicate<class_2680> IGNORES = input -> input != null &&
            input.method_26164(ModBlocks.BULLET_IGNORE_BLOCKS);

    public static class_3965 rayTraceBlocks(class_1937 level, class_3959 context) {
        return performRayTrace(context, (rayTraceContext, blockPos) -> {
            class_2680 blockState = level.method_8320(blockPos);
            // 这里添加判断方块是否可以穿透，如果可以穿透则返回 null
            List<String> ids = AmmoConfig.PASS_THROUGH_BLOCKS.get();
            class_2960 blockId = class_7923.field_41175.method_10221(blockState.method_26204());
            if (blockId != null && ids.contains(blockId.toString())) {
                return null;
            }
            // tag
            if (IGNORES.test(blockState)) {
                return null;
            }
            return getBlockHitResult(level, rayTraceContext, blockPos, blockState);
        }, (rayTraceContext) -> {
            class_243 vec3 = rayTraceContext.method_17750().method_1020(rayTraceContext.method_17747());
            return class_3965.method_17778(rayTraceContext.method_17747(), class_2350.method_10142(vec3.field_1352, vec3.field_1351, vec3.field_1350), class_2338.method_49638(rayTraceContext.method_17747()));
        });
    }

    @Nullable
    private static class_3965 getBlockHitResult(class_1937 level, class_3959 rayTraceContext, class_2338 blockPos, class_2680 blockState) {
        class_3610 fluidState = level.method_8316(blockPos);
        class_243 startVec = rayTraceContext.method_17750();
        class_243 endVec = rayTraceContext.method_17747();
        class_265 blockShape = rayTraceContext.method_17748(blockState, level, blockPos);
        class_3965 blockResult = level.method_17745(startVec, endVec, blockPos, blockShape, blockState);
        class_265 fluidShape = rayTraceContext.method_17749(fluidState, level, blockPos);
        class_3965 fluidResult = fluidShape.method_1092(startVec, endVec, blockPos);
        double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.method_17750().method_1025(blockResult.method_17784());
        double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.method_17750().method_1025(fluidResult.method_17784());
        return blockDistance <= fluidDistance ? blockResult : fluidResult;
    }

    private static <T> T performRayTrace(class_3959 context, BiFunction<class_3959, class_2338, T> hitFunction, Function<class_3959, T> missFactory) {
        class_243 startVec = context.method_17750();
        class_243 endVec = context.method_17747();
        if (!startVec.equals(endVec)) {
            double startX = class_3532.method_16436(-0.0000001, endVec.field_1352, startVec.field_1352);
            double startY = class_3532.method_16436(-0.0000001, endVec.field_1351, startVec.field_1351);
            double startZ = class_3532.method_16436(-0.0000001, endVec.field_1350, startVec.field_1350);
            double endX = class_3532.method_16436(-0.0000001, startVec.field_1352, endVec.field_1352);
            double endY = class_3532.method_16436(-0.0000001, startVec.field_1351, endVec.field_1351);
            double endZ = class_3532.method_16436(-0.0000001, startVec.field_1350, endVec.field_1350);

            int blockX = class_3532.method_15357(endX);
            int blockY = class_3532.method_15357(endY);
            int blockZ = class_3532.method_15357(endZ);

            class_2338.class_2339 mutablePos = new class_2338.class_2339(blockX, blockY, blockZ);
            T t = hitFunction.apply(context, mutablePos);
            if (t != null) {
                return t;
            }

            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = class_3532.method_17822(deltaX);
            int signY = class_3532.method_17822(deltaY);
            int signZ = class_3532.method_17822(deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double) signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double) signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double) signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0D - class_3532.method_15385(endX) : class_3532.method_15385(endX));
            double d13 = d10 * (signY > 0 ? 1.0D - class_3532.method_15385(endY) : class_3532.method_15385(endY));
            double d14 = d11 * (signZ > 0 ? 1.0D - class_3532.method_15385(endZ) : class_3532.method_15385(endZ));

            while (d12 <= 1.0D || d13 <= 1.0D || d14 <= 1.0D) {
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }

                T t1 = hitFunction.apply(context, mutablePos.method_10103(blockX, blockY, blockZ));
                if (t1 != null) {
                    return t1;
                }
            }
        }
        return missFactory.apply(context);
    }
}
