/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAttachment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public interface AttachmentItemDataAccessor
extends IAttachment {
    public static final String ATTACHMENT_ID_TAG = "AttachmentId";
    public static final String SKIN_ID_TAG = "Skin";
    public static final String ZOOM_NUMBER_TAG = "ZoomNumber";
    public static final String LASER_COLOR_TAG = "LaserColor";

    public static boolean isAttachmentLike(class_2487 tag) {
        return tag.method_10573(ATTACHMENT_ID_TAG, 8);
    }

    @Nonnull
    public static class_2960 getAttachmentIdFromTag(@Nullable class_2487 nbt) {
        if (nbt == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        if (AttachmentItemDataAccessor.isAttachmentLike(nbt)) {
            class_2960 attachmentId = class_2960.method_12829((String)nbt.method_10558(ATTACHMENT_ID_TAG));
            return Objects.requireNonNullElse(attachmentId, DefaultAssets.EMPTY_ATTACHMENT_ID);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    public static int getZoomNumberFromTag(@Nullable class_2487 nbt) {
        if (nbt == null) {
            return 0;
        }
        if (nbt.method_10573(ZOOM_NUMBER_TAG, 3)) {
            return nbt.method_10550(ZOOM_NUMBER_TAG);
        }
        return 0;
    }

    public static void setZoomNumberToTag(class_2487 nbt, int zoomNumber) {
        nbt.method_10569(ZOOM_NUMBER_TAG, zoomNumber);
    }

    public static void setLaserColorToTag(class_2487 nbt, int color) {
        nbt.method_10569(LASER_COLOR_TAG, color);
    }

    @Override
    @Nonnull
    default public class_2960 getAttachmentId(class_1799 attachmentStack) {
        class_2487 nbt = ((class_9279)attachmentStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return AttachmentItemDataAccessor.getAttachmentIdFromTag(nbt);
    }

    @Override
    default public void setAttachmentId(class_1799 attachmentStack, @Nullable class_2960 attachmentId) {
        attachmentStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            if (attachmentId != null) {
                tag.method_10582(ATTACHMENT_ID_TAG, attachmentId.toString());
            }
        }));
    }

    @Override
    @Nullable
    default public class_2960 getSkinId(class_1799 attachmentStack) {
        class_2487 nbt = ((class_9279)attachmentStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (nbt.method_10573(SKIN_ID_TAG, 8)) {
            return class_2960.method_12829((String)nbt.method_10558(SKIN_ID_TAG));
        }
        return null;
    }

    @Override
    default public void setSkinId(class_1799 attachmentStack, @Nullable class_2960 skinId) {
        attachmentStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> {
            if (skinId != null) {
                tag.method_10582(SKIN_ID_TAG, skinId.toString());
            } else {
                tag.method_10551(SKIN_ID_TAG);
            }
        }));
    }

    @Override
    default public int getZoomNumber(class_1799 attachmentStack) {
        class_2487 nbt = ((class_9279)attachmentStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return AttachmentItemDataAccessor.getZoomNumberFromTag(nbt);
    }

    @Override
    default public void setZoomNumber(class_1799 attachmentStack, int zoomNumber) {
        attachmentStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> AttachmentItemDataAccessor.setZoomNumberToTag(tag, zoomNumber)));
    }

    @Override
    default public boolean hasCustomLaserColor(class_1799 attachmentStack) {
        class_2487 nbt = ((class_9279)attachmentStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        return nbt.method_10573(LASER_COLOR_TAG, 3);
    }

    @Override
    default public int getLaserColor(class_1799 attachmentStack) {
        class_2487 nbt = ((class_9279)attachmentStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (!this.hasCustomLaserColor(attachmentStack)) {
            return 0xFF0000;
        }
        return nbt.method_10550(LASER_COLOR_TAG);
    }

    @Override
    default public void setLaserColor(class_1799 attachmentStack, int color) {
        attachmentStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, data -> data.method_57451(tag -> AttachmentItemDataAccessor.setLaserColorToTag(tag, color)));
    }
}

