/*
 * This file contains code originally derived from the Iris Shaders mod
 * licensed under the GNU LGPL v3 License.
 *
 * As permitted by section 3 of the GNU Lesser General Public License v3,
 * this file is now licensed under the GNU GPL v3 License.
 *
 * This file has been modified by MUKSC on 2025-06-24.
 * The modifications were made to remove dependency on the original project.
 *
 * Copyright (C) 2025  MUKSC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package com.tacz.guns.client.renderer.other;

import cn.sh1rocu.tacz.mixin.accessor.GameRendererAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.compat.iris.IrisCompat;
import org.joml.Matrix4f;

import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;

// From TACZ-1.21.1
public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    public static final float DEPTH = 0.125F;

    private class_4587 setupGlState(class_757 gameRenderer, class_4184 camera, float tickDelta) {
        final class_4587 poseStack = new class_4587();

        // We need to scale the matrix by 0.125 so the hand doesn't clip through blocks.
        Matrix4f scaleMatrix = new Matrix4f().scale(1F, 1F, DEPTH);
        scaleMatrix.mul(gameRenderer.method_22973(((GameRendererAccessor) gameRenderer).tacz$getFov(camera, tickDelta, false)));
        gameRenderer.method_22709(scaleMatrix);

        poseStack.method_34426();

        ((GameRendererAccessor) gameRenderer).tacz$bobHurt(poseStack, tickDelta);

        if (class_310.method_1551().field_1690.method_42448().method_41753()) {
            ((GameRendererAccessor) gameRenderer).tacz$bobView(poseStack, tickDelta);
        }

        return poseStack;
    }

    public void renderSolid(Consumer<class_4587> renderer, float tickDelta, class_4184 camera, class_757 gameRenderer) {
        if (IrisCompat.isPackInUseQuick()) {
            renderer.accept(null);
            return;
        }

        Matrix4f projection = RenderSystem.getProjectionMatrix();

        class_4587 poseStack = setupGlState(gameRenderer, camera, tickDelta);

        poseStack.method_22903();

        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set(poseStack.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();

        class_746 playerEntity = class_310.method_1551().field_1724;
        float f2 = class_3532.method_16439(tickDelta, playerEntity.field_3914, playerEntity.field_3916);
        float f3 = class_3532.method_16439(tickDelta, playerEntity.field_3931, playerEntity.field_3932);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((playerEntity.method_5695(tickDelta) - f2) * 0.1F));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((playerEntity.method_5705(tickDelta) - f3) * 0.1F));

        renderer.accept(poseStack);

        class_310.method_1551().method_16011().method_15407();

        gameRenderer.method_22709(projection);

        poseStack.method_22909();
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }
}