package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.item.IGun;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;

public class AttachmentLockCommand {
    private static final String ATTACHMENT_LOCK_NAME = "attachment_lock";
    private static final String ENTITY = "target";
    private static final String GUN_ATTACHMENT_LOCK = "AttachmentLock";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> attachmentLock = class_2170.method_9247(ATTACHMENT_LOCK_NAME);
        RequiredArgumentBuilder<class_2168, class_2300> entities = class_2170.method_9244(ENTITY, class_2186.method_9306());
        RequiredArgumentBuilder<class_2168, Boolean> locked = class_2170.method_9244(GUN_ATTACHMENT_LOCK, BoolArgumentType.bool());
        attachmentLock.then(entities.then(locked.executes(AttachmentLockCommand::setAttachmentLock)));
        return attachmentLock;
    }

    private static int setAttachmentLock(CommandContext<class_2168> context) throws CommandSyntaxException {
        var entities = class_2186.method_9317(context, ENTITY);
        int cnt = 0;
        boolean locked = BoolArgumentType.getBool(context, GUN_ATTACHMENT_LOCK);
        for (class_1297 entity : entities) {
            if (entity instanceof class_1309 living) {
                class_1799 stack = living.method_6047();
                if (stack.method_7909() instanceof IGun iGun) {
                    iGun.setAttachmentLock(stack, locked);
                    cnt++;
                }
            }
        }
        return cnt;
    }
}
