package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record ClientMessageUnloadAttachment(int gunSlotIndex,
                                            AttachmentType attachmentType) implements class_8710 {
    public static final class_8710.class_9154<ClientMessageUnloadAttachment> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "client_unload_attachment")
    );
    public static final class_9139<class_9129, ClientMessageUnloadAttachment> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_49675, message -> message.gunSlotIndex,
            class_9135.method_56368(AttachmentType.CODEC), message -> message.attachmentType,
            ClientMessageUnloadAttachment::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(ClientMessageUnloadAttachment message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            class_1661 inventory = player.method_31548();
            class_1799 gunItem = inventory.method_5438(message.gunSlotIndex);
            IGun iGun = IGun.getIGunOrNull(gunItem);
            if (iGun != null) {
                class_1799 attachmentItem = iGun.getAttachment(player.method_56673(), gunItem, message.attachmentType);
                if (!attachmentItem.method_7960() && inventory.method_7394(attachmentItem)) {
                    iGun.unloadAttachment(player.method_56673(), gunItem, message.attachmentType);
                    // 刷新配件数据
                    AttachmentPropertyManager.postChangeEvent(player, gunItem);
                    // 如果卸载的是扩容弹匣，吐出所有子弹
                    if (message.attachmentType == AttachmentType.EXTENDED_MAG) {
                        iGun.dropAllAmmo(player, gunItem);
                    }
                    player.field_7498.method_7623();
                    NetworkHandler.sendToClientPlayer(ServerMessageRefreshRefitScreen.INSTANCE, player);
                }
            }
        });
    }
}