package com.tacz.guns.network.message.event;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.event.common.GunDrawEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record ServerMessageGunDraw(int entityId, class_1799 previousGunItem,
                                   class_1799 currentGunItem) implements class_8710 {
    public static final class_8710.class_9154<ServerMessageGunDraw> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "server_gun_draw")
    );
    public static final class_9139<class_9129, ServerMessageGunDraw> STREAM_CODEC = class_9139.method_56436(
            class_9135.field_49675, message -> message.entityId,
            class_1799.field_49268, message -> message.previousGunItem,
            class_1799.field_49268, message -> message.currentGunItem,
            ServerMessageGunDraw::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(ServerMessageGunDraw message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> doClientEvent(message));
    }

    @Environment(EnvType.CLIENT)
    private static void doClientEvent(ServerMessageGunDraw message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (level.method_8469(message.entityId) instanceof class_1309 livingEntity) {
            GunDrawEvent gunDrawEvent = new GunDrawEvent(livingEntity, message.previousGunItem, message.currentGunItem, LogicalSide.CLIENT);
            GunDrawEvent.CALLBACK.invoker().post(gunDrawEvent);
        }
    }
}