package com.tacz.guns.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.init.ModParticles;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class BulletHoleOption implements class_2394 {
    public static final MapCodec<BulletHoleOption> CODEC = RecordCodecBuilder.mapCodec(builder ->
            builder.group(Codec.INT.fieldOf("dir").forGetter(option -> option.direction.ordinal()),
                    Codec.LONG.fieldOf("pos").forGetter(option -> option.pos.method_10063()),
                    Codec.STRING.fieldOf("ammo_id").forGetter(option -> option.ammoId),
                    Codec.STRING.fieldOf("gun_id").forGetter(option -> option.gunId),
                    Codec.STRING.optionalFieldOf("gun_display_id", DefaultAssets.DEFAULT_GUN_DISPLAY_ID.toString()).forGetter(option -> option.gunDisplayId)
            ).apply(builder, BulletHoleOption::new));
    public static final class_9139<class_9129, BulletHoleOption> STREAM_CODEC = class_9139.method_56906(
            class_9135.field_49675, (option) -> option.direction.ordinal(),
            class_9135.field_48551, (option) -> option.pos.method_10063(),
            class_9135.field_48554, BulletHoleOption::getAmmoId,
            class_9135.field_48554, BulletHoleOption::getGunId,
            class_9135.field_48554, BulletHoleOption::getGunDisplayId,
            BulletHoleOption::new
    );

    private final class_2350 direction;
    private final class_2338 pos;
    private final String ammoId;
    private final String gunId;
    private final String gunDisplayId;

    public BulletHoleOption(int dir, long pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = class_2350.values()[dir];
        this.pos = class_2338.method_10092(pos);
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public BulletHoleOption(class_2350 dir, class_2338 pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = dir;
        this.pos = pos;
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public String getAmmoId() {
        return ammoId;
    }

    public String getGunId() {
        return gunId;
    }

    public String getGunDisplayId() {
        return gunDisplayId;
    }

    @Override
    public class_2396<?> method_10295() {
        return ModParticles.BULLET_HOLE;
    }
}