/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.refit;

import cn.sh1rocu.tacz.util.forge.ExtendedSlider;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.util.LaserColorUtil;
import java.awt.Color;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class HSVSliderGroup {
    private final class_1661 inventory;
    private final int gunItemIndex;
    private final AttachmentType type;
    private final LaserColorSlider hueSlider;
    private final LaserColorSlider saturationSlider;

    public HSVSliderGroup(int x, int y, int width, int height, class_1661 inventory, int gunItemIndex, @NotNull AttachmentType type) {
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.type = type;
        int color = this.getColor(type);
        float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
        this.hueSlider = new LaserColorSlider(x, y, width, height, this, hsb[0]);
        this.saturationSlider = new LaserColorSlider(x, y + 2 + height, width, height, this, hsb[1]);
    }

    public LaserColorSlider getHueSlider() {
        return this.hueSlider;
    }

    public LaserColorSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    public void apply() {
        class_1799 gun = this.inventory.method_5438(this.gunItemIndex);
        class_1792 class_17922 = gun.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            int rgb_new = Color.HSBtoRGB((float)this.hueSlider.getValue(), (float)this.saturationSlider.getValue(), 1.0f);
            if (this.type == AttachmentType.NONE) {
                iGun.setLaserColor(gun, rgb_new);
                return;
            }
            class_1799 laser = iGun.getAttachment((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), gun, this.type);
            class_1792 class_17923 = laser.method_7909();
            if (class_17923 instanceof IAttachment) {
                IAttachment iAttachment = (IAttachment)class_17923;
                iAttachment.setLaserColor(laser, rgb_new);
            }
        }
    }

    private int getColor(AttachmentType type) {
        if (this.inventory == null) {
            return 0xFF0000;
        }
        class_1799 gun = this.inventory.method_5438(this.gunItemIndex);
        class_1792 class_17922 = gun.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            if (type == AttachmentType.NONE) {
                return LaserColorUtil.getLaserColor(gun);
            }
            class_1799 attachment = iGun.getAttachment((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), gun, type);
            return LaserColorUtil.getLaserColor(attachment);
        }
        return 0xFF0000;
    }

    public static class LaserColorSlider
    extends ExtendedSlider {
        private final HSVSliderGroup parent;

        public LaserColorSlider(int x, int y, int width, int height, HSVSliderGroup parent, double current) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), 0.0, 1.0, current, 0.01, 0, true);
            this.parent = parent;
        }

        @Override
        protected void method_25344() {
            this.parent.apply();
        }
    }
}

