/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.listener.camera;

import com.tacz.guns.api.client.animation.AnimationListener;
import com.tacz.guns.api.client.animation.ObjectAnimationChannel;
import com.tacz.guns.client.model.listener.camera.CameraAnimationObject;
import com.tacz.guns.util.math.MathUtil;
import org.joml.Quaternionf;

public class CameraRotateListener
implements AnimationListener {
    private final CameraAnimationObject camera;

    public CameraRotateListener(CameraAnimationObject camera) {
        this.camera = camera;
    }

    @Override
    public void update(float[] values, boolean blend) {
        if (values.length == 4) {
            values = MathUtil.toEulerAngles(values);
        }
        float xRot = values[0];
        float yRot = values[1];
        float zRot = -values[2];
        if (blend) {
            float[] q = MathUtil.toQuaternion(xRot, yRot, zRot);
            Quaternionf quaternion = MathUtil.toQuaternion(q);
            MathUtil.blendQuaternion(this.camera.rotationQuaternion, quaternion);
        } else {
            MathUtil.toQuaternion(xRot, yRot, zRot, this.camera.rotationQuaternion);
        }
    }

    @Override
    public float[] initialValue() {
        return MathUtil.toQuaternion(this.camera.cameraRenderer.getRotateAngleX(), this.camera.cameraRenderer.getRotateAngleY(), this.camera.cameraRenderer.getRotateAngleZ());
    }

    @Override
    public ObjectAnimationChannel.ChannelType getType() {
        return ObjectAnimationChannel.ChannelType.ROTATION;
    }
}

