/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import cn.sh1rocu.tacz.api.event.ViewportEvent;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.event.CameraSetupEvent;
import com.tacz.guns.client.event.FirstPersonRenderGunEvent;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.TransformScale;
import com.tacz.guns.util.RenderDistance;
import com.tacz.guns.util.math.MathUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GunItemRendererWrapper
extends AnimateGeoItemRenderer<BedrockGunModel, GunAnimationStateContext> {
    private static final SlotModel SLOT_GUN_MODEL = new SlotModel();
    private static BedrockGunModel lastModel = null;
    public static final Vector3f muzzleRenderOffset = new Vector3f();

    @Override
    public GunAnimationStateContext initContext(class_1799 stack, class_1657 player, float partialTick) {
        GunAnimationStateContext context = new GunAnimationStateContext();
        this.updateContext(context, stack, player, partialTick);
        return context;
    }

    @Override
    public void updateContext(GunAnimationStateContext context, class_1799 stack, class_1657 player, float partialTick) {
        context.setPartialTicks(partialTick);
        context.setCurrentGunItem(stack);
    }

    @Override
    public void tryInit(class_1799 stack, class_1657 player, float partialTick) {
        super.tryInit(stack, player, partialTick);
    }

    @Override
    public void tryExit(class_1799 stack, long putAwayTime) {
        LuaAnimationStateMachine<GunAnimationStateContext> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.processContextIfExist(context -> {
            context.setPutAwayTime((float)putAwayTime / 1000.0f);
            context.setCurrentGunItem(stack);
        });
        if (stateMachine.isInitialized()) {
            stateMachine.trigger("put_away");
            KeepingItemRenderer.getRenderer().keep(stack, putAwayTime);
            stateMachine.exit();
            stateMachine.setExitingTime(putAwayTime + 50L);
        }
    }

    @Override
    public long getPutAwayTime(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(stack)).map(index -> (long)(index.getGunData().getPutAwayTime() * 1000.0f)).orElse(0L);
        }
        return 0L;
    }

    @Override
    @Nullable
    public LuaAnimationStateMachine<GunAnimationStateContext> getStateMachine(class_1799 stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getAnimationStateMachine).orElse(null);
    }

    @Override
    public BedrockGunModel getModel(class_1799 stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getGunModel).orElse(null);
    }

    @Override
    public class_2960 getTextureLocation(class_1799 stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getModelTexture).orElse(null);
    }

    @Override
    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, class_1799 stack, class_746 player) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        Optional.ofNullable(this.getModel(stack)).ifPresent(model -> {
            if (lastModel != model) {
                model.cleanCameraAnimationTransform();
                lastModel = model;
            }
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_60646().method_60637(false);
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            this.applyLevelCameraAnimation(event, stack, multiplier);
        });
    }

    @Override
    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, class_1799 stack, class_746 player) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        Optional.ofNullable(this.getModel(stack)).ifPresent(model -> {
            class_4587 poseStack = event.getPoseStack();
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_60646().method_60637(false);
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            Quaternionf quaternion = MathUtil.multiplyQuaternion(model.getCameraAnimationObject().rotationQuaternion, multiplier);
            poseStack.method_22907(quaternion);
            model.cleanCameraAnimationTransform();
        });
    }

    @Override
    public void renderFirstPerson(class_746 player, class_1799 stack, class_811 ctx, class_4587 poseStack, class_4597 bufferSource, int light, float partialTick) {
        if (!(stack.method_7909() instanceof IGun)) {
            return;
        }
        TimelessAPI.getGunDisplay(stack).ifPresent(display -> {
            BedrockGunModel gunModel = display.getGunModel();
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (gunModel == null) {
                return;
            }
            animationStateMachine.processContextIfExist(context -> this.updateContext((GunAnimationStateContext)context, stack, (class_1657)player, partialTick));
            animationStateMachine.update();
            poseStack.method_22903();
            float xRotOffset = class_3532.method_16439((float)partialTick, (float)player.field_3914, (float)player.field_3916);
            float yRotOffset = class_3532.method_16439((float)partialTick, (float)player.field_3931, (float)player.field_3932);
            float xRot = player.method_5695(partialTick) - xRotOffset;
            float yRot = player.method_5705(partialTick) - yRotOffset;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(xRot * -0.1f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yRot * -0.1f));
            BedrockPart rootNode = gunModel.getRootNode();
            if (rootNode != null) {
                xRot = (float)Math.tanh(xRot / 25.0f) * 25.0f;
                yRot = (float)Math.tanh(yRot / 25.0f) * 25.0f;
                rootNode.offsetX += yRot * 0.1f / 16.0f / 3.0f;
                rootNode.offsetY += -xRot * 0.1f / 16.0f / 3.0f;
                rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(xRot * 0.05f));
                rootNode.additionalQuaternion.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(yRot * 0.05f));
            }
            poseStack.method_46416(0.0f, 1.5f, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            FirstPersonRenderGunEvent.applyFirstPersonGunTransform(player, stack, poseStack, gunModel, partialTick);
            MuzzleFlashRender.isSelf = true;
            ShellRender.isSelf = true;
            boolean renderHand = gunModel.getRenderHand();
            if (RefitTransform.getOpeningProgress() != 0.0f) {
                gunModel.setRenderHand(false);
            }
            class_1921 renderType = class_1921.method_23576((class_2960)display.getModelTexture());
            gunModel.render(poseStack, stack, ctx, renderType, light, class_4608.field_21444);
            GunItemRendererWrapper.cacheMuzzlePosition(poseStack, gunModel);
            gunModel.setRenderHand(renderHand);
            poseStack.method_22909();
            gunModel.cleanAnimationTransform();
            MuzzleFlashRender.isSelf = false;
            ShellRender.isSelf = false;
        });
    }

    private static void cacheMuzzlePosition(class_4587 poseStack, BedrockGunModel gunModel) {
        if (gunModel.getMuzzleFlashPosPath() != null) {
            poseStack.method_22903();
            for (BedrockPart bedrockPart : gunModel.getMuzzleFlashPosPath()) {
                bedrockPart.translateAndRotateAndScale(poseStack);
            }
            Matrix4f pose = poseStack.method_23760().method_23761();
            double itemRenderFov = CameraSetupEvent.ITEM_MODEL_FOV_DYNAMICS.get();
            double levelRenderFov = CameraSetupEvent.WORLD_FOV_DYNAMICS.get();
            poseStack.method_22909();
            muzzleRenderOffset.set((double)pose.m30(), (double)pose.m31(), (double)pose.m32() * Math.tan(itemRenderFov / 2.0 * Math.PI / 180.0) / Math.tan(levelRenderFov / 2.0 * Math.PI / 180.0));
        }
    }

    @Override
    public void method_3166(@Nonnull class_1799 stack, @Nonnull class_811 transformType, @Nonnull class_4587 poseStack, @Nonnull class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        if (!(stack.method_7909() instanceof IGun)) {
            return;
        }
        poseStack.method_22903();
        TimelessAPI.getGunDisplay(stack).ifPresentOrElse(gunIndex -> {
            class_2960 gunTexture;
            BedrockGunModel gunModel;
            if (transformType == class_811.field_4321 || transformType == class_811.field_4322) {
                return;
            }
            if (transformType == class_811.field_4323) {
                return;
            }
            if (transformType == class_811.field_4317) {
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
                class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580((class_2960)gunIndex.getSlotTexture()));
                SLOT_GUN_MODEL.method_60879(poseStack, buffer, pPackedLight, pPackedOverlay);
                return;
            }
            Pair<BedrockGunModel, class_2960> lodModel = gunIndex.getLodModel();
            if (lodModel == null || RenderDistance.inRenderHighPolyModelDistance(poseStack)) {
                gunModel = gunIndex.getGunModel();
                gunTexture = gunIndex.getModelTexture();
            } else {
                gunModel = (BedrockGunModel)lodModel.getLeft();
                gunTexture = (class_2960)lodModel.getRight();
            }
            poseStack.method_22904(0.5, 2.0, 0.5);
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            GunItemRendererWrapper.applyPositioningTransform(transformType, gunIndex.getTransform().getScale(), gunModel, poseStack);
            GunItemRendererWrapper.applyScaleTransform(transformType, gunIndex.getTransform().getScale(), poseStack);
            class_1921 renderType = class_1921.method_23576((class_2960)gunTexture);
            gunModel.render(poseStack, stack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580((class_2960)class_1047.method_4539()));
            SLOT_GUN_MODEL.method_60879(poseStack, buffer, pPackedLight, pPackedOverlay);
        });
        poseStack.method_22909();
    }

    private static void applyPositioningTransform(class_811 transformType, TransformScale scale, BedrockGunModel model, class_4587 poseStack) {
        switch (transformType) {
            case field_4319: {
                GunItemRendererWrapper.applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
                break;
            }
            case field_4318: {
                GunItemRendererWrapper.applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
                break;
            }
            case field_4320: 
            case field_4323: {
                GunItemRendererWrapper.applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
            }
        }
    }

    private static void applyScaleTransform(class_811 transformType, TransformScale scale, class_4587 poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case field_4319: {
                vector3f = scale.getFixed();
                break;
            }
            case field_4318: {
                vector3f = scale.getGround();
                break;
            }
            case field_4320: 
            case field_4323: {
                vector3f = scale.getThirdPerson();
            }
        }
        if (vector3f != null) {
            poseStack.method_22904(0.0, 1.5, 0.0);
            poseStack.method_22905(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.method_22904(0.0, -1.5, 0.0);
        }
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, class_4587 poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        poseStack.method_22904(0.0, 1.5, 0.0);
        for (int i = nodePath.size() - 1; i >= 0; --i) {
            BedrockPart t = nodePath.get(i);
            poseStack.method_22907(class_7833.field_40713.rotation(t.xRot));
            poseStack.method_22907(class_7833.field_40715.rotation(t.yRot));
            poseStack.method_22907(class_7833.field_40717.rotation(t.zRot));
            if (t.getParent() != null) {
                poseStack.method_46416(-t.x * scale.x() / 16.0f, -t.y * scale.y() / 16.0f, -t.z * scale.z() / 16.0f);
                continue;
            }
            poseStack.method_46416(-t.x * scale.x() / 16.0f, (1.5f - t.y / 16.0f) * scale.y(), -t.z * scale.z() / 16.0f);
        }
        poseStack.method_22904(0.0, -1.5, 0.0);
    }
}

