/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.util.ResourceScanner;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class JsonDataManager<T>
extends class_4080<Map<class_2960, JsonElement>>
implements IdentifiableResourceReloadListener {
    protected final Map<class_2960, T> dataMap = Maps.newHashMap();
    private final Gson gson;
    private final Class<T> dataClass;
    private final Marker marker;
    private final class_7654 fileToIdConverter;
    public final class_2960 ID;

    public JsonDataManager(Class<T> dataClass, Gson pGson, String directory, String marker) {
        this(dataClass, pGson, class_7654.method_45114((String)directory), marker);
    }

    public JsonDataManager(Class<T> dataClass, Gson pGson, class_7654 fileToIdConverter, String marker) {
        this.gson = pGson;
        this.dataClass = dataClass;
        this.marker = MarkerFactory.getMarker((String)marker);
        this.ID = class_2960.method_60655((String)"tacz", (String)this.getMarker().getName().toLowerCase());
        this.fileToIdConverter = fileToIdConverter;
    }

    @NotNull
    protected Map<class_2960, JsonElement> prepare(class_3300 pResourceManager, class_3695 pProfiler) {
        return ResourceScanner.scanDirectory(pResourceManager, this.fileToIdConverter, this.gson);
    }

    protected void apply(Map<class_2960, JsonElement> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        this.dataMap.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            class_2960 id = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                T data = this.parseJson(element);
                if (data == null) continue;
                this.dataMap.put(id, data);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                GunMod.LOGGER.error(this.marker, "Failed to load data file {}", (Object)id, (Object)e);
            }
        }
    }

    protected T parseJson(JsonElement element) {
        return (T)this.gson.fromJson(element, this.getDataClass());
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Gson getGson() {
        return this.gson;
    }

    public T getData(class_2960 id) {
        return this.dataMap.get(id);
    }

    public Map<class_2960, T> getAllData() {
        return this.dataMap;
    }

    public class_2960 getFabricId() {
        return this.ID;
    }
}

