/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.block;

import com.google.common.collect.Sets;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.util.HitboxHelper;
import com.tacz.guns.util.block.BlockRayTrace;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class ProjectileExplosion
extends class_1927 {
    private static final class_5362 DEFAULT_CONTEXT = new class_5362();
    private final class_1937 level;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final float radius;
    private final boolean knockback;
    private final class_1297 owner;
    private final class_1297 exploder;
    private final class_5362 damageCalculator;

    public ProjectileExplosion(class_1937 level, class_1297 owner, class_1297 exploder, @Nullable class_1282 source, @Nullable class_5362 damageCalculator, double x, double y, double z, float power, float radius, boolean knockback, class_1927.class_4179 mode) {
        super(level, exploder, source, damageCalculator, x, y, z, radius, ((Boolean)AmmoConfig.EXPLOSIVE_AMMO_FIRE.get()).booleanValue(), mode, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11236, (class_6880)class_3417.field_15152);
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
        this.radius = radius;
        this.owner = owner;
        this.exploder = exploder;
        this.damageCalculator = damageCalculator == null ? DEFAULT_CONTEXT : damageCalculator;
        this.knockback = knockback;
    }

    public void method_8348() {
        this.level.method_33596(this.exploder, (class_6880)class_5712.field_28178, class_2338.method_49637((double)this.x, (double)this.y, (double)this.z));
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int x = 0; x < i; ++x) {
            for (int y = 0; y < i; ++y) {
                block2: for (int z = 0; z < i; ++z) {
                    if (x != 0 && x != i - 1 && y != 0 && y != i - 1 && z != 0 && z != i - 1) continue;
                    double d0 = (float)x / (float)(i - 1) * 2.0f - 1.0f;
                    double d1 = (float)y / (float)(i - 1) * 2.0f - 1.0f;
                    double d2 = (float)z / (float)(i - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.field_9229.method_43057() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        class_2338 pos = class_2338.method_49637((double)blockX, (double)blockY, (double)blockZ);
                        class_2680 blockState = this.level.method_8320(pos);
                        class_3610 fluidState = this.level.method_8316(pos);
                        if (!this.level.method_24794(pos)) continue block2;
                        Optional optional = this.damageCalculator.method_29555((class_1927)this, (class_1922)this.level, pos, blockState, fluidState);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + f1) * f1;
                        }
                        if (f > 0.0f && this.damageCalculator.method_29554((class_1927)this, (class_1922)this.level, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)f1;
                        blockY += d1 * (double)f1;
                        blockZ += d2 * (double)f1;
                    }
                }
            }
        }
        this.method_8346().addAll(set);
        float radius = this.radius;
        int minX = class_3532.method_15357((double)(this.x - (double)radius - 1.0));
        int maxX = class_3532.method_15357((double)(this.x + (double)radius + 1.0));
        int minY = class_3532.method_15357((double)(this.y - (double)radius - 1.0));
        int maxY = class_3532.method_15357((double)(this.y + (double)radius + 1.0));
        int minZ = class_3532.method_15357((double)(this.z - (double)radius - 1.0));
        int maxZ = class_3532.method_15357((double)(this.z + (double)radius + 1.0));
        radius *= 2.0f;
        List entities = this.level.method_8335(this.exploder, new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        class_243 explosionPos = new class_243(this.x, this.y, this.z);
        for (class_1297 entity : entities) {
            class_1657 player;
            double deltaZ;
            double deltaY;
            double deltaX;
            double strength;
            if (entity.method_5659((class_1927)this)) continue;
            class_238 boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.owner);
            double minDistance = radius;
            class_243[] d = new class_243[15];
            if (!(entity instanceof class_1309)) {
                strength = Math.sqrt(entity.method_5707(explosionPos)) * 2.0 / (double)radius;
                deltaX = entity.method_23317() - this.x;
                deltaY = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y;
                deltaZ = entity.method_23321() - this.z;
            } else {
                deltaX = (boundingBox.field_1320 + boundingBox.field_1323) / 2.0;
                deltaY = (boundingBox.field_1325 + boundingBox.field_1322) / 2.0;
                deltaZ = (boundingBox.field_1324 + boundingBox.field_1321) / 2.0;
                d[0] = new class_243(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
                d[1] = new class_243(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1324);
                d[2] = new class_243(boundingBox.field_1323, boundingBox.field_1325, boundingBox.field_1321);
                d[3] = new class_243(boundingBox.field_1320, boundingBox.field_1322, boundingBox.field_1321);
                d[4] = new class_243(boundingBox.field_1323, boundingBox.field_1325, boundingBox.field_1324);
                d[5] = new class_243(boundingBox.field_1320, boundingBox.field_1322, boundingBox.field_1324);
                d[6] = new class_243(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1321);
                d[7] = new class_243(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
                d[8] = new class_243(boundingBox.field_1323, deltaY, deltaZ);
                d[9] = new class_243(boundingBox.field_1320, deltaY, deltaZ);
                d[10] = new class_243(deltaX, boundingBox.field_1322, deltaZ);
                d[11] = new class_243(deltaX, boundingBox.field_1325, deltaZ);
                d[12] = new class_243(deltaX, deltaY, boundingBox.field_1321);
                d[13] = new class_243(deltaX, deltaY, boundingBox.field_1324);
                d[14] = new class_243(deltaX, deltaY, deltaZ);
                for (int s = 0; s < 15; ++s) {
                    class_3965 result = BlockRayTrace.rayTraceBlocks(this.level, new class_3959(explosionPos, d[s], class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                    minDistance = result.method_17783() != class_239.class_240.field_1332 ? Math.min(minDistance, explosionPos.method_1022(d[s])) : minDistance;
                }
                strength = minDistance * 2.0 / (double)radius;
                deltaX -= this.x;
                deltaY -= this.y;
                deltaZ -= this.z;
            }
            if (strength > 1.0) continue;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            }
            double damage = 1.0 - strength;
            entity.method_5643(this.field_9193, (float)damage * this.power);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                damage *= 1.0 - livingEntity.method_45325(class_5134.field_51580);
            }
            float multiplier = this.power * radius / 500.0f;
            if (!((Boolean)AmmoConfig.EXPLOSIVE_AMMO_KNOCK_BACK.get()).booleanValue() || !this.knockback) continue;
            entity.method_18799(entity.method_18798().method_1031(deltaX * damage * (double)multiplier, deltaY * damage * (double)multiplier, deltaZ * damage * (double)multiplier));
            if (!(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_7337() && player.method_31549().field_7479) continue;
            this.method_8351().put(player, new class_243(deltaX * damage * (double)multiplier, deltaY * damage * (double)multiplier, deltaZ * damage * (double)multiplier));
        }
    }
}

