package cn.sh1rocu.tacz.mixin.client;

import com.tacz.guns.client.event.PreventsHotbarEvent;
import com.tacz.guns.client.event.RenderCrosshairEvent;
import com.tacz.guns.compat.immediatelyfast.ImmediatelyFastCompat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Mixin(class_329.class)
public class GuiMixin {
    @Inject(method = "renderSlot", at = @At("HEAD"))
    private void tacz$renderHotbarItemPre(class_332 guiGraphics, int x, int y, class_9779 deltaTracker, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        ImmediatelyFastCompat.renderHotbarItem(stack, true);
    }

    @Inject(method = "renderSlot", at = @At("RETURN"))
    private void tacz$renderHotbarItemPost(class_332 guiGraphics, int x, int y, class_9779 deltaTracker, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        ImmediatelyFastCompat.renderHotbarItem(stack, false);
    }

    @Inject(method = "renderHotbarAndDecorations", at = @At("HEAD"), cancellable = true)
    private void tacz$onRender(class_332 guiGraphics, class_9779 deltaTracker, CallbackInfo ci) {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        PreventsHotbarEvent.onRenderHotbarEvent(cancelled);
        if (cancelled.get()) {
            ci.cancel();
        }
    }

    @Inject(method = "renderCrosshair", at = @At("HEAD"), cancellable = true)
    private void tacz$renderCrosshairPre(class_332 guiGraphics, class_9779 deltaTracker, CallbackInfo ci) {
        RenderCrosshairEvent.onRenderOverlay(guiGraphics, class_310.method_1551().method_22683(), deltaTracker, ci);
    }
}
