package com.tacz.guns.api;

import com.google.common.reflect.TypeToken;
import net.minecraft.class_156;

public record GunProperty<T>(
        String name,
        Class<T> type
) {
    public static <T> GunProperty<T> of(String name, Class<T> type) {
        return class_156.method_654(new GunProperty<>(name, type), property -> GunProperties.ALL.put(name, property));
    }

    @SuppressWarnings("unchecked")
    public static <T> GunProperty<T> of(String name, TypeToken<T> type) {
        return class_156.method_654(new GunProperty<>(name, (Class<T>) type.getRawType()), property -> GunProperties.ALL.put(name, property));
    }
}
