package com.tacz.guns.api;

import java.lang.annotation.*;
import net.minecraft.class_243;

/**
 * 文档性质的注解。被注解的枪械属性生效时的值可以被逻辑脚本修改。
 *
 * @author ChloePrime
 * @see com.tacz.guns.entity.EntityKineticBullet
 * @see com.tacz.guns.entity.EntityKineticBullet#getDamage(class_243)
 * @see com.tacz.guns.item.ModernKineticGunScriptAPI#shootOnce(boolean)
 * @since 1.1.7
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.SOURCE)
@Repeatable(Holder.class)
public @interface ValueModifiableAtRuntime {
    /**
     * 运行时值的类型
     */
    Class<?> value();
}


/**
 * @author ChloePrime
 * @since 1.1.7
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.SOURCE)
@interface Holder {
    ValueModifiableAtRuntime[] value();
}