package com.tacz.guns.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2754;
import net.minecraft.class_6088;
import org.jetbrains.annotations.Nullable;

/**
 * 双方块的枪械工作台，2x1x1
 */
public class GunSmithTableBlockB extends AbstractGunSmithTableBlock {
    public static final MapCodec<GunSmithTableBlockB> CODEC = method_54094((properties) -> new GunSmithTableBlockB());
    public static final class_2754<class_2742> PART = class_2741.field_12483;

    public GunSmithTableBlockB() {
        super();
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(PART, class_2742.field_12557));
    }

    @Override
    protected MapCodec<GunSmithTableBlockB> method_53969() {
        return field_46280;
    }

    private static class_2350 getNeighbourDirection(class_2742 bedPart, class_2350 direction) {
        return bedPart == class_2742.field_12557 ? direction : direction.method_10153();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, PART);
    }


    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042().method_10170();
        class_2338 clickedPos = context.method_8037();
        class_2338 relative = clickedPos.method_10093(direction);
        class_1937 level = context.method_8045();
        if (level.method_8320(relative).method_26166(context) && level.method_8621().method_11952(relative)) {
            return this.method_9564().method_11657(FACING, direction);
        }
        return null;
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (!worldIn.field_9236) {
            class_2338 relative = pos.method_10093(state.method_11654(FACING));
            worldIn.method_8652(relative, state.method_11657(PART, class_2742.field_12560), class_2248.field_31036);
            worldIn.method_8408(pos, class_2246.field_10124);
            state.method_30101(worldIn, pos, class_2248.field_31036);
        }
    }

    @Override
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 blockState, class_1657 player) {
        // 用于抑制创造模式下摧毁head方块时foot的掉落
        if (!level.field_9236 && player.method_7337()) {
            class_2742 bedPart = blockState.method_11654(PART);
            if (bedPart == class_2742.field_12557) {
                class_2338 blockpos = pos.method_10093(getNeighbourDirection(bedPart, blockState.method_11654(FACING)));
                class_2680 blockstate = level.method_8320(blockpos);
                if (blockstate.method_27852(this) && blockstate.method_11654(PART) == class_2742.field_12560) {
                    level.method_8652(blockpos, class_2246.field_10124.method_9564(), class_2248.field_31036 | class_2248.field_31032);
                    level.method_8444(player, class_6088.field_31144, blockpos, class_2248.method_9507(blockstate));
                }
            }
        }
        return super.method_9576(level, pos, blockState, player);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (direction == getNeighbourDirection(state.method_11654(PART), state.method_11654(FACING))) {
            return facingState.method_27852(this) && facingState.method_11654(PART) != state.method_11654(PART) ? state : class_2246.field_10124.method_9564();
        } else {
            return super.method_9559(state, direction, facingState, level, currentPos, facingPos);
        }
    }

    @Override
    public boolean isRoot(class_2680 blockState) {
        return blockState.method_11654(PART).equals(class_2742.field_12557);
    }

    @Override
    public float parseRotation(class_2350 direction) {
        return 90 - 90 * direction.method_10161();
    }

    @Override
    public class_2338 getRootPos(class_2338 pos, class_2680 blockState) {
        return blockState.method_11654(PART).equals(class_2742.field_12557) ? pos : pos.method_10093(getNeighbourDirection(class_2742.field_12560, blockState.method_11654(FACING)));
    }
}
