package com.tacz.guns.client.event;

import cn.sh1rocu.tacz.api.event.ClientPlayerNetworkEvent;
import com.tacz.guns.api.client.event.SwapItemWithOffHand;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IAnimationItem;
import com.tacz.guns.api.item.IGun;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;

@Environment(EnvType.CLIENT)
public class InventoryEvent {
    // 用于切枪逻辑
    private static int oldHotbarSelected = -1;
    private static class_1799 oldHotbarSelectItem = class_1799.field_8037;

    public static void onPlayerChangeSelect(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1661 inventory = player.method_31548();
        // 玩家切换选中框的情况
        if (oldHotbarSelected != inventory.field_7545) {
            if (oldHotbarSelected == -1) {
                IClientPlayerGunOperator.fromLocalPlayer(player).draw(class_1799.field_8037);
            } else {
                IClientPlayerGunOperator.fromLocalPlayer(player).draw(inventory.method_5438(oldHotbarSelected));
            }
            oldHotbarSelected = inventory.field_7545;
            oldHotbarSelectItem = inventory.method_5438(inventory.field_7545).method_7972();
            return;
        }
        // 玩家选中的物品改变的情况
        class_1799 currentItem = inventory.method_5438(inventory.field_7545);
        if (currentItem.method_7909() instanceof IAnimationItem item) {
            if (!item.isSame(oldHotbarSelectItem, currentItem)) {
                IClientPlayerGunOperator.fromLocalPlayer(player).draw(oldHotbarSelectItem);
            }
        } else {
            if (!class_1799.method_7973(oldHotbarSelectItem, currentItem)) {
                IClientPlayerGunOperator.fromLocalPlayer(player).draw(oldHotbarSelectItem);
            }
        }

        if (!class_1799.method_7973(oldHotbarSelectItem, currentItem)) {
            oldHotbarSelectItem = currentItem.method_7972();
        }
    }

    public static void onPlayerSwapMainHand(SwapItemWithOffHand event) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        IClientPlayerGunOperator.fromLocalPlayer(player).draw(player.method_6047());
    }

    public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        // 离开游戏时重置客户端 draw 状态
        oldHotbarSelected = -1;
        oldHotbarSelectItem = class_1799.field_8037;
    }

    private static boolean isSame(class_1799 i, class_1799 j) {
        IGun iGun1 = IGun.getIGunOrNull(i);
        IGun iGun2 = IGun.getIGunOrNull(j);
        if (iGun1 != null && iGun2 != null) {
            return iGun1.getGunId(i).equals(iGun2.getGunId(j));
        }
        if (i.method_7960() || j.method_7960()) {
            return i.method_7960() && j.method_7960();
        }
        return class_1799.method_7973(i, j);
    }
}
