package com.tacz.guns.client.event;

import cn.sh1rocu.tacz.api.event.RenderLivingEvent;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.config.util.HeadShotAABBConfigRead;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import net.minecraft.class_7923;

@Environment(EnvType.CLIENT)
public class RenderHeadShotAABB {
    public static void onRenderEntity(RenderLivingEvent.Post<?, ?> event) {
        boolean canRender = class_310.method_1551().method_1561().method_3958();
        if (!canRender) {
            return;
        }
        if (!RenderConfig.HEAD_SHOT_DEBUG_HITBOX.get()) {
            return;
        }
        class_1309 entity = event.getEntity();
        class_2960 entityId = class_7923.field_41177.method_10221(entity.method_5864());
        class_238 aabb = HeadShotAABBConfigRead.getAABB(entityId);
        if (aabb == null) {
            float width = entity.method_17681();
            float eyeHeight = entity.method_5751();
            // 扩张 0.01，避免和原版显示重合
            aabb = new class_238(-width / 2, eyeHeight - 0.25, -width / 2, width / 2, eyeHeight + 0.25, width / 2).method_1014(0.01);
        }
        class_4588 buffer = event.getMultiBufferSource().getBuffer(class_1921.method_23594());
        class_761.method_22982(event.getPoseStack(), buffer, aabb, 1.0F, 1.0F, 0.0F, 1.0F);
    }
}
