package com.tacz.guns.client.resource.pojo.display.ammo;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.client.resource.pojo.display.IDisplay;
import javax.annotation.Nullable;
import net.minecraft.class_2960;

public class AmmoDisplay implements IDisplay {
    @SerializedName("model")
    private class_2960 modelLocation;

    @SerializedName("texture")
    private class_2960 modelTexture;

    @Nullable
    @SerializedName("slot")
    private class_2960 slotTextureLocation;

    @Nullable
    @SerializedName("entity")
    private AmmoEntityDisplay ammoEntity;

    @Nullable
    @SerializedName("shell")
    private ShellDisplay shellDisplay;

    @Nullable
    @SerializedName("particle")
    private AmmoParticle particle;

    @SerializedName("tracer_color")
    private String tracerColor = "0xFFFFFF";

    @Nullable
    @SerializedName("transform")
    private AmmoTransform transform;

    public class_2960 getModelLocation() {
        return modelLocation;
    }

    public class_2960 getModelTexture() {
        return modelTexture;
    }

    @Nullable
    public class_2960 getSlotTextureLocation() {
        return slotTextureLocation;
    }

    @Nullable
    public AmmoEntityDisplay getAmmoEntity() {
        return ammoEntity;
    }

    @Nullable
    public ShellDisplay getShellDisplay() {
        return shellDisplay;
    }

    @Nullable
    public AmmoParticle getParticle() {
        return particle;
    }

    public String getTracerColor() {
        return tracerColor;
    }

    @Nullable
    public AmmoTransform getTransform() {
        return transform;
    }

    @Override
    public void init() {
        if (modelTexture != null) {
            modelTexture = converter.method_45112(modelTexture);
        }
        if (slotTextureLocation != null) {
            slotTextureLocation = converter.method_45112(slotTextureLocation);
        }
        if (ammoEntity != null && ammoEntity.modelTexture != null) {
            ammoEntity.modelTexture = converter.method_45112(ammoEntity.modelTexture);
        }
        if (shellDisplay != null && shellDisplay.modelTexture != null) {
            shellDisplay.modelTexture = converter.method_45112(shellDisplay.modelTexture);
        }
    }
}
