package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.entity.sync.core.DataEntry;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public record ServerMessageUpdateEntityData(int entityId,
                                            List<DataEntry<?, ?>> entries) implements class_8710 {
    public static final class_8710.class_9154<ServerMessageUpdateEntityData> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "server_update_entity_data")
    );
    public static final class_9139<class_9129, ServerMessageUpdateEntityData> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_49675, message -> message.entityId,
            DataEntry.STREAM_CODEC.method_56433(class_9135.method_56374(class_2371::method_37434)), message -> message.entries,
            ServerMessageUpdateEntityData::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(ServerMessageUpdateEntityData message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> onHandle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(ServerMessageUpdateEntityData message) {
        class_1937 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(message.entityId);
        if (entity == null) {
            return;
        }
        SyncedEntityData instance = SyncedEntityData.instance();
        message.entries.forEach(entry -> instance.set(entity, entry.getKey(), entry.getValue()));
    }
}