package com.tacz.guns.resource.pojo.data.block;

import com.google.gson.*;
import com.mojang.serialization.JsonOps;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.init.ModItems;
import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;

public record TabConfig(class_2960 id, String name, Function<class_7225.class_7874, class_1799> icon) {
    public static final class_2960 TAB_AMMO = class_2960.method_60655(GunMod.MOD_ID, "ammo");

    public static final class_2960 TAB_PISTOL = class_2960.method_60655(GunMod.MOD_ID, "pistol");
    public static final class_2960 TAB_SNIPER = class_2960.method_60655(GunMod.MOD_ID, "sniper");
    public static final class_2960 TAB_RIFLE = class_2960.method_60655(GunMod.MOD_ID, "rifle");
    public static final class_2960 TAB_SHOTGUN = class_2960.method_60655(GunMod.MOD_ID, "shotgun");
    public static final class_2960 TAB_SMG = class_2960.method_60655(GunMod.MOD_ID, "smg");
    public static final class_2960 TAB_RPG = class_2960.method_60655(GunMod.MOD_ID, "rpg");
    public static final class_2960 TAB_MG = class_2960.method_60655(GunMod.MOD_ID, "mg");

    public static final class_2960 TAB_SCOPE = class_2960.method_60655(GunMod.MOD_ID, "scope");
    public static final class_2960 TAB_MUZZLE = class_2960.method_60655(GunMod.MOD_ID, "muzzle");
    public static final class_2960 TAB_STOCK = class_2960.method_60655(GunMod.MOD_ID, "stock");
    public static final class_2960 TAB_GRIP = class_2960.method_60655(GunMod.MOD_ID, "grip");
    public static final class_2960 TAB_EXTENDED_MAG = class_2960.method_60655(GunMod.MOD_ID, "extended_mag");
    public static final class_2960 TAB_LASER = class_2960.method_60655(GunMod.MOD_ID, "laser");

    public static final class_2960 TAB_MISC = class_2960.method_60655(GunMod.MOD_ID, "misc");
    public static final class_2960 TAB_EMPTY = class_2960.method_60655(GunMod.MOD_ID, "empty");

    public static final List<TabConfig> DEFAULT_TABS = List.of(
            new TabConfig(TabConfig.TAB_AMMO, "tacz.type.ammo.name", (provider) -> AmmoItemBuilder.create().setId(DefaultAssets.DEFAULT_AMMO_ID).build()),
            new TabConfig(TabConfig.TAB_PISTOL, "tacz.type.pistol.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "glock_17")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_SNIPER, "tacz.type.sniper.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "ai_awp")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_RIFLE, "tacz.type.rifle.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "ak47")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_SHOTGUN, "tacz.type.shotgun.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "db_short")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_SMG, "tacz.type.smg.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "hk_mp5a5")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_RPG, "tacz.type.rpg.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "rpg7")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_MG, "tacz.type.mg.name", (provider) -> GunItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "m249")).forceBuild(provider)),
            new TabConfig(TabConfig.TAB_SCOPE, "tacz.type.scope.name", (provider) -> AttachmentItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "scope_acog_ta31")).build()),
            new TabConfig(TabConfig.TAB_MUZZLE, "tacz.type.muzzle.name", (provider) -> AttachmentItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "muzzle_compensator_trident")).build()),
            new TabConfig(TabConfig.TAB_STOCK, "tacz.type.stock.name", (provider) -> AttachmentItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "stock_militech_b5")).build()),
            new TabConfig(TabConfig.TAB_GRIP, "tacz.type.grip.name", (provider) -> AttachmentItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "grip_magpul_afg_2")).build()),
            new TabConfig(TabConfig.TAB_EXTENDED_MAG, "tacz.type.extended_mag.name", (provider) -> AttachmentItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "extended_mag_3")).build()),
            new TabConfig(TabConfig.TAB_LASER, "tacz.type.laser.name", (provider) -> AttachmentItemBuilder.create().setId(class_2960.method_60655(GunMod.MOD_ID, "laser_compact")).build()),
            new TabConfig(TabConfig.TAB_MISC, "tacz.type.misc.name", (provider) -> ModItems.GUN_SMITH_TABLE.method_7854())
    );

    public static class Deserializer implements JsonDeserializer<TabConfig> {
        @Override
        public TabConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("TabConfig must be a JSON object");
            }
            JsonObject object = json.getAsJsonObject();
            if (!object.has("id") || !object.get("id").isJsonPrimitive()) {
                throw new JsonParseException("TabConfig must have an id");
            }
            class_2960 id = context.deserialize(object.get("id"), class_2960.class);
            class_1799 icon = class_1799.field_24671.parse(JsonOps.INSTANCE, class_3518.method_15296(object, "icon")).getOrThrow();
            String name = class_3518.method_15253(object, "name", "tacz.type.unknown.name");
            return new TabConfig(id, name, (provider) -> icon);
        }
    }

    @NotNull
    public class_2561 getName() {
        return class_2561.method_43471(name == null ? "tacz.type.unknown.name" : name);
    }
}