/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator.animation;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunDrawEvent;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import com.tacz.guns.compat.playeranimator.animation.PlayerAnimatorAssetManager;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_742;

public class AnimationManager {
    public static boolean hasPlayerAnimator3rd(GunDisplayInstance display) {
        class_2960 location = display.getPlayerAnimator3rd();
        if (location == null) {
            return false;
        }
        return PlayerAnimatorAssetManager.get().containsKey(location);
    }

    public static boolean isFlying(class_742 player) {
        return !player.method_24828() && player.method_31549().field_7479;
    }

    public static void playRotationAnimation(class_742 player, GunDisplayInstance display) {
        String animationName = "empty";
        class_2960 dataId = PlayerAnimatorCompat.ROTATION_ANIMATION;
        class_2960 animator3rd = display.getPlayerAnimator3rd();
        if (animator3rd == null) {
            return;
        }
        if (!PlayerAnimatorAssetManager.get().containsKey(animator3rd)) {
            return;
        }
        PlayerAnimatorAssetManager.get().getAnimations(animator3rd, animationName).ifPresent(keyframeAnimation -> {
            PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((class_742)player);
            ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
            if (modifierLayer == null) {
                return;
            }
            AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
            modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
        });
    }

    public static void playLowerAnimation(class_742 player, GunDisplayInstance display, float limbSwingAmount) {
        if (AnimationManager.isPlayerLie(player)) {
            return;
        }
        if (player.method_5854() != null) {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "ride_lower");
            return;
        }
        if (AnimationManager.isFlying(player)) {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "hold_lower");
            return;
        }
        if (player.method_5624()) {
            if (player.method_18376() == class_4050.field_18081) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "crouch_walk_lower");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "run_lower");
            }
            return;
        }
        if ((double)limbSwingAmount > 0.05) {
            if (player.method_18376() == class_4050.field_18081) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "crouch_walk_lower");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "walk_lower");
            }
            return;
        }
        if (player.method_18376() == class_4050.field_18081) {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "crouch_lower");
        } else {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "hold_lower");
        }
    }

    public static void playLoopUpperAnimation(class_742 player, GunDisplayInstance display, float limbSwingAmount) {
        IGunOperator operator = IGunOperator.fromLivingEntity((class_1309)player);
        float aimingProgress = operator.getSynAimingProgress();
        if (aimingProgress <= 0.0f) {
            if (!AnimationManager.isFlying(player) && player.method_5624()) {
                if (AnimationManager.isPlayerLie(player)) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_move");
                } else if (player.method_18376() == class_4050.field_18081) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "crouch_walk_upper");
                } else {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "run_upper");
                }
                return;
            }
            if (!AnimationManager.isFlying(player) && (double)limbSwingAmount > 0.05) {
                if (AnimationManager.isPlayerLie(player)) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_move");
                } else if (player.method_18376() == class_4050.field_18081) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "crouch_walk_upper");
                } else {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "walk_upper");
                }
                return;
            }
            if (AnimationManager.isPlayerLie(player)) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "hold_upper");
            }
        } else if (AnimationManager.isPlayerLie(player)) {
            if (!AnimationManager.isFlying(player) && (double)limbSwingAmount > 0.05) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_move");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_aim");
            }
        } else {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "aim_upper");
        }
    }

    public static void playLoopAnimation(class_742 player, GunDisplayInstance display, class_2960 dataId, String animationName) {
        class_2960 animator3rd = display.getPlayerAnimator3rd();
        if (animator3rd == null) {
            return;
        }
        if (!PlayerAnimatorAssetManager.get().containsKey(animator3rd)) {
            return;
        }
        PlayerAnimatorAssetManager.get().getAnimations(animator3rd, animationName).ifPresent(keyframeAnimation -> {
            KeyframeAnimationPlayer animationPlayer;
            PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((class_742)player);
            ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
            if (modifierLayer == null) {
                return;
            }
            IAnimation patt0$temp = modifierLayer.getAnimation();
            if (patt0$temp instanceof KeyframeAnimationPlayer && (animationPlayer = (KeyframeAnimationPlayer)patt0$temp).isActive()) {
                String name;
                Object extraDataName = animationPlayer.getData().extraData.get("name");
                if (extraDataName instanceof String && !animationName.equals(name = (String)extraDataName)) {
                    AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
                    modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                }
                return;
            }
            AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
            modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
        });
    }

    public static void playOnceAnimation(class_742 player, GunDisplayInstance display, class_2960 dataId, String animationName) {
        class_2960 animator3rd = display.getPlayerAnimator3rd();
        if (animator3rd == null) {
            return;
        }
        if (!PlayerAnimatorAssetManager.get().containsKey(animator3rd)) {
            return;
        }
        PlayerAnimatorAssetManager.get().getAnimations(animator3rd, animationName).ifPresent(keyframeAnimation -> {
            PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((class_742)player);
            ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
            if (modifierLayer == null) {
                return;
            }
            IAnimation animation = modifierLayer.getAnimation();
            if (animation == null || !animation.isActive()) {
                AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
                modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
            }
        });
    }

    public static void stopAllAnimation(class_742 player) {
        AnimationManager.stopAllAnimation(player, 8);
    }

    public static void stopAllAnimation(class_742 player, int fadeTime) {
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOWER_ANIMATION, fadeTime);
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, fadeTime);
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, fadeTime);
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.ROTATION_ANIMATION, fadeTime);
    }

    private static void stopAnimation(class_742 player, class_2960 dataId, int fadeTime) {
        PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((class_742)player);
        ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
        if (modifierLayer != null && modifierLayer.isActive()) {
            AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)fadeTime, (Ease)Ease.INOUTSINE);
            modifierLayer.replaceAnimationWithFade(fadeModifier, null);
        }
    }

    private static boolean isPlayerLie(class_742 player) {
        return !player.method_5681() && player.method_18376() == class_4050.field_18079;
    }

    public void onFire(GunShootEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        class_1309 shooter = event.getShooter();
        if (!(shooter instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)shooter;
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724 == player && class_310.method_1551().field_1690.method_31044().method_31034()) {
            return;
        }
        class_1799 gunItemStack = event.getGunItemStack();
        IGun iGun = IGun.getIGunOrNull(gunItemStack);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(gunItemStack).ifPresent(index -> {
            IGunOperator operator = IGunOperator.fromLivingEntity((class_1309)player);
            float aimingProgress = operator.getSynAimingProgress();
            if (aimingProgress <= 0.0f) {
                if (AnimationManager.isPlayerLie(player)) {
                    AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "lie_normal_fire");
                } else {
                    AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "normal_fire_upper");
                }
            } else if (AnimationManager.isPlayerLie(player)) {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "lie_aim_fire");
            } else {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "aim_fire_upper");
            }
        });
    }

    public void onReload(GunReloadEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        class_1309 shooter = event.getEntity();
        if (!(shooter instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)shooter;
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724 == player && class_310.method_1551().field_1690.method_31044().method_31034()) {
            return;
        }
        class_1799 gunItemStack = event.getGunItemStack();
        IGun iGun = IGun.getIGunOrNull(gunItemStack);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(gunItemStack).ifPresent(index -> {
            if (AnimationManager.isPlayerLie(player)) {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "lie_reload");
            } else {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "reload_upper");
            }
        });
    }

    public void onMelee(GunMeleeEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        class_1309 shooter = event.getShooter();
        if (!(shooter instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)shooter;
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724 == player && class_310.method_1551().field_1690.method_31044().method_31034()) {
            return;
        }
        class_1799 gunItemStack = event.getGunItemStack();
        IGun iGun = IGun.getIGunOrNull(gunItemStack);
        if (iGun == null) {
            return;
        }
        int randomIndex = shooter.method_59922().method_43048(3);
        String animationName = switch (randomIndex) {
            case 0 -> "melee_upper";
            case 1 -> "melee_2_upper";
            default -> "melee_3_upper";
        };
        TimelessAPI.getGunDisplay(gunItemStack).ifPresent(index -> AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, animationName));
    }

    public void onDraw(GunDrawEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        class_1309 entity = event.getEntity();
        if (!(entity instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)entity;
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724 == player && class_310.method_1551().field_1690.method_31044().method_31034()) {
            return;
        }
        class_1799 currentGunItem = event.getCurrentGunItem();
        class_1799 previousGunItem = event.getPreviousGunItem();
        if (currentGunItem.method_7909() instanceof IGun && previousGunItem.method_7909() instanceof IGun) {
            AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, 8);
            AnimationManager.stopAnimation(player, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, 8);
            AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOWER_ANIMATION, 8);
        }
    }
}

