/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator.animation;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import dev.kosmx.playerAnim.api.IPlayable;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import dev.kosmx.playerAnim.minecraftApi.codec.AnimationCodecs;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public class PlayerAnimatorAssetManager
extends class_4080<Map<class_2960, HashMap<String, KeyframeAnimation>>>
implements IdentifiableResourceReloadListener {
    private static PlayerAnimatorAssetManager INSTANCE;
    private final class_7654 filetoidconverter = new class_7654("player_animator", ".json");
    private final HashMap<class_2960, HashMap<String, KeyframeAnimation>> animations = new HashMap();
    public static final class_2960 ID;

    public static PlayerAnimatorAssetManager get() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerAnimatorAssetManager();
        }
        return INSTANCE;
    }

    void putAnimation(class_2960 id, InputStream stream) throws IOException {
        Collection keyframeAnimations = AnimationCodecs.deserialize((String)"json", () -> stream);
        for (IPlayable playable : keyframeAnimations) {
            if (!(playable instanceof KeyframeAnimation)) continue;
            KeyframeAnimation animation = (KeyframeAnimation)playable;
            Object v = animation.extraData.get("name");
            if (!(v instanceof String)) continue;
            String text = (String)v;
            String name = PlayerAnimationRegistry.serializeTextToString((String)text).toLowerCase(Locale.ENGLISH);
            this.animations.computeIfAbsent(id, k -> Maps.newHashMap()).put(name, animation);
        }
    }

    Optional<KeyframeAnimation> getAnimations(class_2960 id, String name) {
        HashMap<String, KeyframeAnimation> animationHashMap = this.animations.get(id);
        if (animationHashMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(animationHashMap.get(name));
    }

    public boolean containsKey(class_2960 id) {
        return this.animations.containsKey(id);
    }

    public void clearAll() {
        this.animations.clear();
    }

    protected Map<class_2960, HashMap<String, KeyframeAnimation>> prepare(class_3300 manager, class_3695 profiler) {
        HashMap output = Maps.newHashMap();
        for (Map.Entry entry : this.filetoidconverter.method_45113(manager).entrySet()) {
            class_2960 resourcelocation = (class_2960)entry.getKey();
            class_2960 resourcelocation1 = this.filetoidconverter.method_45115(resourcelocation);
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    Collection keyframeAnimations = AnimationCodecs.deserialize((String)"json", () -> stream);
                    for (IPlayable playable : keyframeAnimations) {
                        if (!(playable instanceof KeyframeAnimation)) continue;
                        KeyframeAnimation animation = (KeyframeAnimation)playable;
                        Object v = animation.extraData.get("name");
                        if (!(v instanceof String)) continue;
                        String text = (String)v;
                        String name = PlayerAnimationRegistry.serializeTextToString((String)text).toLowerCase(Locale.ENGLISH);
                        output.computeIfAbsent(resourcelocation1, k -> Maps.newHashMap()).put(name, animation);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                GunMod.LOGGER.warn("Failed to player animation file: {}, entry: {}", (Object)resourcelocation, entry);
            }
        }
        return output;
    }

    protected void apply(Map<class_2960, HashMap<String, KeyframeAnimation>> map, class_3300 manager, class_3695 profiler) {
        this.animations.clear();
        this.animations.putAll(map);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    static {
        ID = class_2960.method_60655((String)"tacz", (String)"pa_asset_manager");
    }
}

