package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IGun;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import java.util.Objects;

public interface AmmoItemDataAccessor extends IAmmo {
    String AMMO_ID_TAG = "AmmoId";

    @Override
    @Nonnull
    default class_2960 getAmmoId(class_1799 ammo) {
        class_2487 nbt = ammo.method_7948();
        if (nbt.method_10573(AMMO_ID_TAG, class_2520.field_33258)) {
            class_2960 gunId = class_2960.method_12829(nbt.method_10558(AMMO_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_AMMO_ID);
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default void setAmmoId(class_1799 ammo, @Nullable class_2960 ammoId) {
        class_2487 nbt = ammo.method_7948();
        if (ammoId != null) {
            nbt.method_10582(AMMO_ID_TAG, ammoId.toString());
            return;
        }
        nbt.method_10582(AMMO_ID_TAG, DefaultAssets.DEFAULT_AMMO_ID.toString());
    }

    @Override
    default boolean isAmmoOfGun(class_1799 gun, class_1799 ammo) {
        if (gun.method_7909() instanceof IGun iGun && ammo.method_7909() instanceof IAmmo iAmmo) {
            class_2960 gunId = iGun.getGunId(gun);
            class_2960 ammoId = iAmmo.getAmmoId(ammo);
            return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals(ammoId)).orElse(false);
        }
        return false;
    }
}
