package com.tacz.guns.compat.kubejs.util;

import cn.sh1rocu.tacz.util.forge.CraftingHelper;
import com.google.gson.JsonObject;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.UtilsJS;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class GunSmithTableResultInfo {
    private static final String TYPE_KEY = "type";
    private static final String ID_KEY = "id";
    private static final String COUNT_KEY = "count";
    private static final String NBT_KEY = "nbt";
    private static final String CUSTOM_ITEM_KEY = "item";
    private static final String OUTPUT_GROUP_KEY = "group";
    private final JsonObject json;

    private GunSmithTableResultInfo() {
        this(new JsonObject());
    }

    private GunSmithTableResultInfo(JsonObject jsonObject) {
        this.json = (jsonObject != null) ? jsonObject : new JsonObject();
    }

    public static GunSmithTableResultInfo create() {
        return new GunSmithTableResultInfo();
    }

    public static GunSmithTableResultInfo createFromJson(JsonObject jsonObject) {
        return new GunSmithTableResultInfo(jsonObject);
    }

    public static GunSmithTableResultInfo createFromItemStack(class_1799 stack) {
        GunSmithTableResultInfo info = create().setType(GunSmithTableResult.CUSTOM);
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty("item", RegistryInfo.ITEM.getId(stack.method_7909()).toString());
        itemJson.addProperty("count", stack.method_7947());
        if (JsonIO.of(stack.method_7969()) != null) {
            itemJson.addProperty("nbt", stack.method_7948().toString());
        }
        info.setCustomItem(itemJson);
        return info;
    }

    /**
     * {@link GunSmithTableResultInfo}的TypeWrapper, 将其他类型转为{@link GunSmithTableResultInfo}
     * object为其他类型时优先解析{@link JsonObject}，其次{@link OutputItem}，再其次{@link class_1799}
     * 之后尝试转化为{@link String}解析为{@link class_2960}
     * 以上均不成功时最终{@link JsonIO#of(Object)}解析
     *
     * @param object 输入待转化对象
     * @return {@link GunSmithTableResultInfo}
     */
    public static GunSmithTableResultInfo of(Object object) {
        if (object instanceof GunSmithTableResultInfo info) {
            return info;
        } else if (object instanceof JsonObject jsonObject) {
            return createFromJson(jsonObject);
        } else if (object instanceof OutputItem outputItem) {
            return createFromItemStack(outputItem.item);
        } else if (object instanceof class_1799 stack) {
            return createFromItemStack(stack);
        }
        String idString = object.toString();
        if (class_2960.method_20207(idString)) {
            class_2960 rl = UtilsJS.getMCID(null, idString);
            TimelessItemWrapper.ItemIndexInfo indexInfo = TimelessItemWrapper.ItemIndexInfo.createFromResourceLocation(rl);
            if (indexInfo.isValidForRecipe()) {
                return create().setType(indexInfo.getParent()).setId(indexInfo.getIndexId());
            }
        }
        class_1799 stack = ItemStackJS.of(object);
        if (!stack.method_7960()) {
            return createFromItemStack(stack);
        }
        //以上都不匹配，默认按JsonObject处理
        return createFromJson(JsonIO.of(object).getAsJsonObject());
    }

    public String getType() {
        return class_3518.method_15265(this.json, TYPE_KEY);
    }

    public GunSmithTableResultInfo setType(String typeName) {
        this.json.addProperty(TYPE_KEY, typeName);
        return this;
    }

    public class_2960 getId() {
        return class_2960.method_12829(class_3518.method_15265(this.json, ID_KEY));
    }

    public GunSmithTableResultInfo setId(class_2960 id) {
        this.json.addProperty(ID_KEY, id.toString());
        return this;
    }

    public class_2487 getNbt() {
        return CraftingHelper.getNBT(this.json.get(NBT_KEY));
    }

    public GunSmithTableResultInfo setNbt(class_2487 nbt) {
        this.json.addProperty(NBT_KEY, nbt.toString());
        return this;
    }

    public int getCount() {
        return Math.max(class_3518.method_15260(this.json, "count"), 1);
    }

    public GunSmithTableResultInfo setCount(int count) {
        this.json.addProperty(COUNT_KEY, count);
        return this;
    }

    public JsonObject getCustomItem() {
        return class_3518.method_15296(this.json, CUSTOM_ITEM_KEY);
    }

    public GunSmithTableResultInfo setCustomItem(JsonObject itemJson) {
        this.json.add(CUSTOM_ITEM_KEY, itemJson);
        return this;
    }

    public GunSmithTableResultInfo setGroupName(String groupName) {
        this.json.addProperty(OUTPUT_GROUP_KEY, groupName);
        return this;
    }

    public GunSmithTableResultInfo setGroup(OutputGroupName group) {
        this.setGroupName(group.getName());
        return this;
    }

    public JsonObject toJson() {
        return json;
    }

    public enum OutputGroupName {
        AMMO("ammo"),
        EXTENDED_MAG("extended_mag"),
        GRIP("grip"),
        MG("mg"),
        MUZZLE("muzzle"),
        PISTOL("pistol"),
        RIFLE("rifle"),
        RPG("rpg"),
        SCOPE("scope"),
        SHOTGUN("shotgun"),
        SMG("smg"),
        SNIPER("sniper"),
        STOCK("stock");

        private final String name;

        OutputGroupName(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }
    }
}
