package com.tacz.guns.entity.sync.core;

import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.Validate;

public class DataEntry<E extends class_1297, T> {
    private final SyncedDataKey<E, T> key;
    private T value;
    private boolean dirty;

    public DataEntry(SyncedDataKey<E, T> key) {
        this.key = key;
        this.value = key.defaultValueSupplier().get();
    }

    public static DataEntry<?, ?> read(class_2540 buffer) {
        SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.method_10816());
        Validate.notNull(key, "Synced key does not exist for id");
        DataEntry<?, ?> entry = new DataEntry<>(key);
        entry.readValue(buffer);
        return entry;
    }

    public SyncedDataKey<E, T> getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value, boolean dirty) {
        this.value = value;
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void write(class_2540 buffer) {
        int id = SyncedEntityData.instance().getInternalId(this.key);
        buffer.method_10804(id);
        this.key.serializer().write(buffer, this.value);
    }

    public void readValue(class_2540 buffer) {
        this.value = this.getKey().serializer().read(buffer);
    }

    public class_2520 writeValue() {
        return this.key.serializer().write(this.value);
    }

    public void readValue(class_2520 nbt) {
        this.value = this.key.serializer().read(nbt);
    }
}
