package com.tacz.guns.util.datafixer;

import com.google.common.collect.ImmutableMap;
import com.tacz.guns.api.DefaultAssets;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

import static com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor.*;
import static com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor.ATTACHMENT_ID_TAG;

public final class AttachmentIdFix {
    private AttachmentIdFix() {
    }

    public static final Map<class_2960, class_2960> OLD_TO_NEW;
    static  {
        OLD_TO_NEW = ImmutableMap.<class_2960, class_2960>builder()
                .put(new class_2960("tacz", "muzzle_silence_knight_qd"), new class_2960("tacz", "muzzle_silencer_knight_qd"))
                .put(new class_2960("tacz", "muzzle_silence_mirage"), new class_2960("tacz", "muzzle_silencer_mirage"))
                .put(new class_2960("tacz", "muzzle_silence_phantom_s1"), new class_2960("tacz", "muzzle_silencer_phantom_s1"))
                .put(new class_2960("tacz", "muzzle_silence_ptilopsis"), new class_2960("tacz", "muzzle_silencer_ptilopsis"))
                .put(new class_2960("tacz", "muzzle_silence_ursus"), new class_2960("tacz", "muzzle_silencer_ursus"))
                .put(new class_2960("tacz", "muzzle_silence_vulture"), new class_2960("tacz", "muzzle_silencer_vulture"))
                .build();
    }

    // 预留 boolean 返回值用于未来使用，"尽可能避免使用 void ，除非这个操作不能提供任何有用的信息"
    public static boolean updateAttachmentIdInTag(class_2487 tag) {
        class_2960 old = getAttachmentIdFromTag(tag);
        if (!old.equals(DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            class_2960 fixed = updateAttachmentId(old);
            if (!old.equals(fixed)) {
                tag.method_10582(ATTACHMENT_ID_TAG, fixed.toString());
                return true;
            }
        }
        return false;
    }

    public static class_2960 updateAttachmentId(class_2960 old) {
        return OLD_TO_NEW.getOrDefault(old, old);
    }
}
