/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.sound;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.sound.GunSoundInstance;
import com.tacz.guns.config.common.GunConfig;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.network.message.ServerMessageSound;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.sound.SoundManager;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SoundPlayManager {
    private static boolean DRY_SOUND_TRACK = true;
    private static GunSoundInstance tmpSoundInstance = null;

    public static GunSoundInstance playClientSound(class_1297 entity, @Nullable class_2960 name, float volume, float pitch, int distance, boolean mono) {
        class_310 minecraft = class_310.method_1551();
        GunSoundInstance instance = new GunSoundInstance(ModSounds.GUN, class_3419.field_15248, volume, pitch, entity, distance, name, mono);
        minecraft.method_1483().method_4873((class_1113)instance);
        return instance;
    }

    public static GunSoundInstance playClientSound(class_1297 entity, @Nullable class_2960 name, float volume, float pitch, int distance) {
        return SoundPlayManager.playClientSound(entity, name, volume, pitch, distance, false);
    }

    public static void stopPlayGunSound() {
        if (tmpSoundInstance != null) {
            tmpSoundInstance.setStop();
        }
    }

    public static void stopPlayGunSound(GunDisplayInstance gunIndex, String animationName) {
        if (tmpSoundInstance != null && tmpSoundInstance.getRegistryName() != null && tmpSoundInstance.getRegistryName().equals((Object)gunIndex.getSounds(animationName))) {
            tmpSoundInstance.setStop();
        }
    }

    public static void playerRefitSound(class_1799 attachmentItem, class_746 player, String soundName) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        if (iAttachment == null) {
            return;
        }
        class_2960 attachmentId = iAttachment.getAttachmentId(attachmentItem);
        TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresent(index -> {
            Map<String, class_2960> sounds = index.getSounds();
            if (sounds.containsKey(soundName)) {
                class_2960 resourceLocation = sounds.get(soundName);
                SoundPlayManager.playClientSound((class_1297)player, resourceLocation, 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
            }
        });
    }

    public static void playShootSound(class_1309 entity, GunDisplayInstance gunIndex, GunData gunData) {
        SoundPlayManager.playClientSound((class_1297)entity, gunIndex.getSounds(SoundManager.SHOOT_SOUND), 0.8f, 0.9f + entity.method_6051().method_43057() * 0.125f, (int)((float)((Integer)GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get()).intValue() * gunData.getFireSound().getFireMultiplier()));
    }

    public static void playSilenceSound(class_1309 entity, GunDisplayInstance gunIndex, GunData gunData) {
        SoundPlayManager.playClientSound((class_1297)entity, gunIndex.getSounds(SoundManager.SILENCE_SOUND), 0.6f, 0.9f + entity.method_6051().method_43057() * 0.125f, (int)((float)((Integer)GunConfig.DEFAULT_GUN_SILENCE_SOUND_DISTANCE.get()).intValue() * gunData.getFireSound().getSilenceMultiplier()));
    }

    public static void playDryFireSound(class_1309 entity, GunDisplayInstance gunIndex) {
        if (DRY_SOUND_TRACK) {
            SoundPlayManager.playClientSound((class_1297)entity, gunIndex.getSounds(SoundManager.DRY_FIRE_SOUND), 1.0f, 0.9f + entity.method_6051().method_43057() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
            DRY_SOUND_TRACK = false;
        }
    }

    public static void resetDryFireSound() {
        DRY_SOUND_TRACK = true;
    }

    public static void playReloadSound(class_1309 entity, GunDisplayInstance display, boolean noAmmo) {
        tmpSoundInstance = noAmmo ? SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.RELOAD_EMPTY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get()) : SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.RELOAD_TACTICAL_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playInspectSound(class_1309 entity, GunDisplayInstance display, boolean noAmmo) {
        tmpSoundInstance = noAmmo ? SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.INSPECT_EMPTY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get()) : SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.INSPECT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playBoltSound(class_1309 entity, GunDisplayInstance display) {
        tmpSoundInstance = SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.BOLT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playDrawSound(class_1309 entity, GunDisplayInstance display) {
        tmpSoundInstance = SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.DRAW_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playPutAwaySound(class_1309 entity, GunDisplayInstance display) {
        tmpSoundInstance = SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.PUT_AWAY_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playFireSelectSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.FIRE_SELECT), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleeBayonetSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.MELEE_BAYONET), 1.0f, 0.9f + entity.method_6051().method_43057() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleePushSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.MELEE_PUSH), 1.0f, 0.9f + entity.method_6051().method_43057() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMeleeStockSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.MELEE_STOCK), 1.0f, 0.9f + entity.method_6051().method_43057() * 0.125f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playHeadHitSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.HEAD_HIT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playFleshHitSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.FLESH_HIT_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playKillSound(class_1309 entity, GunDisplayInstance display) {
        SoundPlayManager.playClientSound((class_1297)entity, display.getSounds(SoundManager.KILL_SOUND), 1.0f, 1.0f, (Integer)GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get());
    }

    public static void playMessageSound(ServerMessageSound message) {
        class_1297 class_12972;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || !((class_12972 = level.method_8469(message.getEntityId())) instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)class_12972;
        class_2960 gunId = message.getGunId();
        class_2960 gunDisplayId = message.getGunDisplayId();
        TimelessAPI.getGunDisplay(gunDisplayId, gunId).ifPresent(index -> {
            String soundName = message.getSoundName();
            class_2960 soundId = index.getSounds(soundName);
            if (soundId == null) {
                return;
            }
            if (SoundManager.SHOOT_3P_SOUND.equals(soundName) || SoundManager.SILENCE_3P_SOUND.equals(soundName)) {
                SoundPlayManager.playClientSound((class_1297)livingEntity, soundId, message.getVolume(), message.getPitch(), message.getDistance(), true);
            } else {
                SoundPlayManager.playClientSound((class_1297)livingEntity, soundId, message.getVolume(), message.getPitch(), message.getDistance());
            }
        });
    }
}

