package cn.sh1rocu.tacz.mixin.common;

import cn.sh1rocu.tacz.api.extension.IEntityAdditionalSpawnData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2596;
import net.minecraft.class_8038;

/**
 * this is needed for {@link IEntityAdditionalSpawnData} to work properly on dedicated servers, since it ends up nesting bundle packets.
 */
@Mixin(class_8038.class)
public class BundlePacketMixin {
    @ModifyVariable(method = "<init>", at = @At("HEAD"), argsOnly = true)
    private static Iterable<class_2596<?>> flattenPackets(Iterable<class_2596<?>> packets) {
        List<class_2596<?>> list = new ArrayList<>();
        recursivelyCollectBundledPackets(packets, list);
        return list;
    }

    @Unique
    private static void recursivelyCollectBundledPackets(Iterable<class_2596<?>> packets, List<class_2596<?>> list) {
        for (class_2596<?> packet : packets) {
            if (packet instanceof class_8038<?> bundle) {
                //noinspection unchecked,rawtypes
                recursivelyCollectBundledPackets((Iterable) bundle.method_48324(), list);
            } else {
                list.add(packet);
            }
        }
    }
}