package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.event.BaseEvent;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;

/**
 * 缓存配件属性修改值时触发的事件
 * <p>
 * 如果有其他模组想要添加自定义的配件属性修改值，可以捕获此事件
 */
public class AttachmentPropertyEvent extends BaseEvent implements KubeJSGunEventPoster<AttachmentPropertyEvent> {
    private final class_1799 gunItem;
    private final AttachmentCacheProperty cacheProperty;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(AttachmentPropertyEvent event);
    }

    public AttachmentPropertyEvent(class_1799 gunItem, AttachmentCacheProperty attachmentProperty) {
        this.gunItem = gunItem;
        this.cacheProperty = attachmentProperty;
    }

    public class_1799 getGunItem() {
        return gunItem;
    }

    public AttachmentCacheProperty getCacheProperty() {
        return cacheProperty;
    }
}
