package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import java.util.Objects;

public interface BlockItemDataAccessor extends IBlock {
    String BLOCK_ID = "BlockId";

    @Override
    @Nonnull
    default class_2960 getBlockId(class_1799 block) {
        class_2487 nbt = block.method_7948();
        if (nbt.method_10573(BLOCK_ID, class_2520.field_33258)) {
            class_2960 gunId = class_2960.method_12829(nbt.method_10558(BLOCK_ID));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_BLOCK_ID);
        }
        return DefaultAssets.EMPTY_BLOCK_ID;
    }

    @Override
    default void setBlockId(class_1799 block, @Nullable class_2960 blockId) {
        class_2487 nbt = block.method_7948();
        if (blockId != null) {
            nbt.method_10582(BLOCK_ID, blockId.toString());
            return;
        }
        nbt.method_10582(BLOCK_ID, DefaultAssets.EMPTY_BLOCK_ID.toString());
    }

}
