package com.tacz.guns.block;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_6088;
import org.jetbrains.annotations.Nullable;

/**
 * 双方块的枪械工作台，1x2x1
 */
public class GunSmithTableBlockC extends AbstractGunSmithTableBlock {
    public static final class_2754<class_2756> HALF = class_2741.field_12533;

    public GunSmithTableBlockC() {
        super();
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(HALF, class_2756.field_12607));
    }


    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, HALF);
    }


    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042().method_10153();
        class_2338 clickedPos = context.method_8037();
        class_2338 above = clickedPos.method_10084();
        class_1937 level = context.method_8045();
        if (level.method_8320(above).method_26166(context) && level.method_8621().method_11952(above)) {
            return this.method_9564().method_11657(FACING, direction);
        }
        return null;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (!world.field_9236) {
            class_2338 above = pos.method_10084();
            world.method_8652(above, state.method_11657(HALF, class_2756.field_12609), class_2248.field_31036);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101(world, pos, class_2248.field_31036);
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        class_2756 half = state.method_11654(HALF);

        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            if (half.equals(class_2756.field_12607) && facing == class_2350.field_11036 || half.equals(class_2756.field_12609) && facing == class_2350.field_11033) {
                // 拆一半另外一半跟着没
                if (!facingState.method_27852(this)) {
                    return class_2246.field_10124.method_9564();
                }
            }
        }

        return state;
    }

    @Override
    public void method_9576(class_1937 level, class_2338 pos, class_2680 blockState, class_1657 player) {
        // 用于抑制创造模式下摧毁upper方块时lower的掉落
        if (!level.field_9236 && player.method_7337()) {
            class_2756 half = blockState.method_11654(HALF);
            if (half == class_2756.field_12609) {
                class_2338 blockpos = pos.method_10074();
                class_2680 blockstate = level.method_8320(blockpos);
                if (blockstate.method_27852(this) && blockstate.method_11654(HALF) == class_2756.field_12607) {
                    level.method_8652(blockpos, class_2246.field_10124.method_9564(), class_2248.field_31036 | class_2248.field_31032);
                    level.method_8444(player, class_6088.field_31144, blockpos, class_2248.method_9507(blockstate));
                }
            }
        }
        super.method_9576(level, pos, blockState, player);
    }

    @Override
    public boolean isRoot(class_2680 blockState) {
        return blockState.method_11654(HALF).equals(class_2756.field_12607);
    }

    @Override
    public class_2338 getRootPos(class_2338 pos, class_2680 blockState) {
        return blockState.method_11654(HALF).equals(class_2756.field_12607) ? pos : pos.method_10074();
    }
}
