package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.item.IGun;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;

public class DummyAmmoCommand {
    private static final String DUMMY_NAME = "dummy";
    private static final String ENTITY = "target";
    private static final String AMOUNT = "dummyAmount";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> dummy = class_2170.method_9247(DUMMY_NAME);
        RequiredArgumentBuilder<class_2168, class_2300> entities = class_2170.method_9244(ENTITY, class_2186.method_9306());
        RequiredArgumentBuilder<class_2168, Integer> amount = class_2170.method_9244(AMOUNT, IntegerArgumentType.integer(0));
        dummy.then(entities.then(amount.executes(DummyAmmoCommand::setDummy)));
        return dummy;
    }

    private static int setDummy(CommandContext<class_2168> context) throws CommandSyntaxException {
        var entities = class_2186.method_9317(context, ENTITY);
        int cnt = 0;
        int amount = IntegerArgumentType.getInteger(context, AMOUNT);
        for (class_1297 entity : entities) {
            if (entity instanceof class_1309 living) {
                class_1799 stack = living.method_6047();
                if (stack.method_7909() instanceof IGun iGun) {
                    iGun.setDummyAmmoAmount(stack, amount);
                    cnt++;
                }
            }
        }
        return cnt;
    }
}
