package com.tacz.guns.item;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.nbt.AmmoBoxItemDataAccessor;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.inventory.tooltip.AmmoBoxTooltip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_638;
import net.minecraft.world.item.*;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public class AmmoBoxItem extends class_1792 implements class_1768, AmmoBoxItemDataAccessor {
    public static final class_2960 PROPERTY_NAME = new class_2960(GunMod.MOD_ID, "ammo_statue");

    public static final int IRON_LEVEL = 0;
    public static final int GOLD_LEVEL = 1;
    public static final int DIAMOND_LEVEL = 2;

    private static final String DISPLAY_TAG = "display";
    private static final String COLOR_TAG = "color";

    private static final int OPEN = 0;
    private static final int CLOSE = 1;

    private static final int CREATIVE_INDEX = 6;
    private static final int ALL_TYPE_CREATIVE_INDEX = 8;

    public AmmoBoxItem() {
        super(new class_1793().method_7889(1));
    }

    @Environment(EnvType.CLIENT)
    public static int getColor(class_1799 stack, int tintIndex) {
        return tintIndex > 0 ? -1 : getTagColor(stack);
    }

    @Environment(EnvType.CLIENT)
    public static float getStatue(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
        int openStatue = OPEN;
        int ammoLevel = IRON_LEVEL;
        if (stack.method_7909() instanceof IAmmoBox iAmmoBox) {
            if (iAmmoBox.isAllTypeCreative(stack)) {
                return ALL_TYPE_CREATIVE_INDEX;
            }
            openStatue = getOpenStatue(stack, iAmmoBox);
            if (iAmmoBox.isCreative(stack)) {
                return openStatue + CREATIVE_INDEX;
            }
            ammoLevel = getLevelStatue(stack, iAmmoBox);
        }
        return openStatue + 2 * ammoLevel;
    }

    private static int getOpenStatue(class_1799 stack, IAmmoBox iAmmoBox) {
        boolean idIsEmpty = iAmmoBox.getAmmoId(stack).equals(DefaultAssets.EMPTY_AMMO_ID);
        boolean countIsZero = iAmmoBox.getAmmoCount(stack) <= 0;
        if (idIsEmpty || countIsZero) {
            return OPEN;
        }
        return CLOSE;
    }

    private static int getLevelStatue(class_1799 stack, IAmmoBox iAmmoBox) {
        return iAmmoBox.getAmmoLevel(stack);
    }

    private static int getTagColor(class_1799 stack) {
        class_2487 compoundtag = stack.method_7941(DISPLAY_TAG);
        return compoundtag != null && compoundtag.method_10573(COLOR_TAG, class_2520.field_33263) ? compoundtag.method_10550(COLOR_TAG) : 0x727d6b;
    }

    @Override
    public boolean method_31566(class_1799 stack, class_1799 pOther, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        return super.method_31566(stack, pOther, slot, action, player, access);
    }

    @Override
    public boolean method_31565(class_1799 ammoBox, class_1735 slot, class_5536 action, class_1657 player) {
        // 右击
        if (action == class_5536.field_27014) {
            // 点击的格子
            class_1799 slotItem = slot.method_7677();
            class_2960 boxAmmoId = this.getAmmoId(ammoBox);

            // 格子为空，那就是取出物品
            if (slotItem.method_7960()) {
                // 创造模式弹药箱不能取出任何东西
                if (isAllTypeCreative(ammoBox) || isCreative(ammoBox)) {
                    return false;
                }
                // 啥也没有，不能取出
                if (boxAmmoId.equals(DefaultAssets.EMPTY_AMMO_ID)) {
                    return false;
                }
                // 数量不对，不能取出
                int boxAmmoCount = this.getAmmoCount(ammoBox);
                if (boxAmmoCount <= 0) {
                    return false;
                }
                TimelessAPI.getCommonAmmoIndex(boxAmmoId).ifPresent(index -> {
                    int takeCount = Math.min(index.getStackSize(), boxAmmoCount);
                    class_1799 takeAmmo = AmmoItemBuilder.create().setId(boxAmmoId).setCount(takeCount).build();
                    slot.method_32756(takeAmmo);

                    int remainCount = boxAmmoCount - takeCount;
                    this.setAmmoCount(ammoBox, remainCount);
                    if (remainCount <= 0) {
                        this.setAmmoId(ammoBox, DefaultAssets.EMPTY_AMMO_ID);
                    }
                    this.playRemoveOneSound(player);
                });
                return true;
            }

            // 如果是子弹
            if (slotItem.method_7909() instanceof IAmmo iAmmo) {
                // 全类型弹药箱不能存入
                if (isAllTypeCreative(ammoBox)) {
                    return false;
                }
                class_2960 slotAmmoId = iAmmo.getAmmoId(slotItem);
                // 格子里的子弹 ID 不对，不能放
                if (slotAmmoId.equals(DefaultAssets.EMPTY_AMMO_ID)) {
                    return false;
                }
                // 如果盒子的子弹 ID 为空，变成当前点击的类型
                if (boxAmmoId.equals(DefaultAssets.EMPTY_AMMO_ID)) {
                    this.setAmmoId(ammoBox, slotAmmoId);
                } else if (!slotAmmoId.equals(boxAmmoId)) {
                    return false;
                }
                TimelessAPI.getCommonAmmoIndex(slotAmmoId).ifPresent(index -> {
                    // 创造模式弹药箱，那就直接存入最大
                    if (isCreative(ammoBox)) {
                        this.setAmmoCount(ammoBox, Integer.MAX_VALUE);
                        return;
                    }
                    int boxAmmoCount = this.getAmmoCount(ammoBox);
                    int boxLevelMultiplier = this.getAmmoLevel(ammoBox) + 1;
                    int maxSize = index.getStackSize() * SyncConfig.AMMO_BOX_STACK_SIZE.get() * boxLevelMultiplier;
                    int needCount = maxSize - boxAmmoCount;
                    class_1799 takeItem = slot.method_32753(slotItem.method_7947(), needCount, player);
                    this.setAmmoCount(ammoBox, boxAmmoCount + takeItem.method_7947());
                });
                // 播放取出声音
                this.playInsertSound(player);
                return true;
            }
        }
        return false;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8F, 0.8F + entity.method_37908().method_8409().method_43057() * 0.4F);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8F, 0.8F + entity.method_37908().method_8409().method_43057() * 0.4F);
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        if (isAllTypeCreative(stack) || isCreative(stack)) {
            return false;
        }
        return !this.getAmmoId(stack).equals(DefaultAssets.EMPTY_AMMO_ID) && this.getAmmoCount(stack) > 0;
    }

    @Override
    public int method_31569(class_1799 stack) {
        class_2960 ammoId = this.getAmmoId(stack);
        int ammoCount = this.getAmmoCount(stack);
        int boxLevelMultiplier = this.getAmmoLevel(stack) + 1;
        double widthPercent = TimelessAPI.getCommonAmmoIndex(ammoId).map(index -> {
            double totalCount = index.getStackSize() * SyncConfig.AMMO_BOX_STACK_SIZE.get() * boxLevelMultiplier;
            return ammoCount / totalCount;
        }).orElse(0d);
        return (int) Math.min(1 + 12 * widthPercent, 13);
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        if (isAllTypeCreative(stack)) {
            return class_2561.method_43471("item.tacz.ammo_box.all_type_creative").method_27692(class_124.field_1064);
        }
        if (isCreative(stack)) {
            return class_2561.method_43471("item.tacz.ammo_box.creative").method_27692(class_124.field_1064);
        }
        int ammoLevel = getAmmoLevel(stack);
        switch (ammoLevel) {
            case GOLD_LEVEL -> {
                return class_2561.method_43471("item.tacz.ammo_box.gold").method_27692(class_124.field_1054);
            }
            case DIAMOND_LEVEL -> {
                return class_2561.method_43471("item.tacz.ammo_box.diamond").method_27692(class_124.field_1075);
            }
            default -> {
                return class_2561.method_43471("item.tacz.ammo_box.iron");
            }
        }
    }

    @Override
    public boolean method_7886(class_1799 stack) {
        if (isAllTypeCreative(stack) || isCreative(stack)) {
            return true;
        }
        return super.method_7886(stack);
    }

    @Override
    public int method_31571(class_1799 stack) {
        return class_3532.method_15369(1 / 3f, 1.0F, 1.0F);
    }

    public static void fillItemCategory(class_1761.class_7704 output) {
        class_1799 ammoBox = ModItems.AMMO_BOX.method_7854();
        if (ammoBox.method_7909() instanceof IAmmoBox iAmmoBox) {
            // 添加普通版本的弹药盒
            output.method_45420(iAmmoBox.setAmmoLevel(ammoBox.method_7972(), IRON_LEVEL));
            output.method_45420(iAmmoBox.setAmmoLevel(ammoBox.method_7972(), GOLD_LEVEL));
            output.method_45420(iAmmoBox.setAmmoLevel(ammoBox.method_7972(), DIAMOND_LEVEL));

            // 添加创造模式弹药盒
            output.method_45420(iAmmoBox.setCreative(ammoBox.method_7972(), false));
            output.method_45420(iAmmoBox.setCreative(ammoBox.method_7972(), true));
        }
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!(stack.method_7909() instanceof IAmmoBox iAmmoBox)) {
            return Optional.empty();
        }
        class_2960 ammoId = iAmmoBox.getAmmoId(stack);
        if (ammoId.equals(DefaultAssets.EMPTY_AMMO_ID)) {
            return Optional.empty();
        }
        int ammoCount = iAmmoBox.getAmmoCount(stack);
        if (ammoCount <= 0) {
            return Optional.empty();
        }
        class_1799 ammoStack = AmmoItemBuilder.create().setId(ammoId).build();
        return Optional.of(new AmmoBoxTooltip(stack, ammoStack, ammoCount));
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 pLevel, List<class_2561> components, class_1836 isAdvanced) {
        if (isAllTypeCreative(stack)) {
            components.add(class_2561.method_43471("tooltip.tacz.ammo_box.usage.all_type_creative").method_27692(class_124.field_1065));
            return;
        }
        if (isCreative(stack)) {
            components.add(class_2561.method_43471("tooltip.tacz.ammo_box.usage.creative.1").method_27692(class_124.field_1054));
            components.add(class_2561.method_43471("tooltip.tacz.ammo_box.usage.creative.2").method_27692(class_124.field_1054));
            return;
        }
        components.add(class_2561.method_43471("tooltip.tacz.ammo_box.usage.deposit").method_27692(class_124.field_1080));
        components.add(class_2561.method_43471("tooltip.tacz.ammo_box.usage.remove").method_27692(class_124.field_1080));
    }
}
