package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.ClientIndexManager;
import com.tacz.guns.resource.network.CommonNetworkCache;
import com.tacz.guns.resource.network.DataType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import java.util.Map;

public class ServerMessageSyncGunPack implements FabricPacket {
    public static final PacketType<ServerMessageSyncGunPack> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_sync_gunpack"), ServerMessageSyncGunPack::new);

    private final Map<DataType, Map<class_2960, String>> cache;

    public ServerMessageSyncGunPack(class_2540 buf) {
        this(buf.method_34067(buf1 -> buf1.method_10818(DataType.class),
                buf2 -> buf2.method_34067(class_2540::method_10810, class_2540::method_19772)));
    }

    public ServerMessageSyncGunPack(Map<DataType, Map<class_2960, String>> cache) {
        this.cache = cache;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_34063(getCache(), class_2540::method_10817, (buf1, map) ->
                buf1.method_34063(map, class_2540::method_10812, class_2540::method_10814));
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
        doSync(this);
    }


    public Map<DataType, Map<class_2960, String>> getCache() {
        return cache;
    }

    @Environment(EnvType.CLIENT)
    private static void doSync(ServerMessageSyncGunPack message) {
        CommonNetworkCache.INSTANCE.fromNetwork(message.cache);
        // 通知客户端重新构建ClientIndex
        ClientIndexManager.reload();
    }
}
