package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;

public class PierceModifier implements IAttachmentModifier<Modifier, Integer> {
    public static final String ID = GunProperties.PIERCE.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new PierceJsonProperty(data.getPierce());
    }

    @Override
    public CacheValue<Integer> initCache(class_1799 gunItem, GunData gunData) {
        int pierce = gunData.getBulletData().getPierce();
        return new CacheValue<>(pierce);
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Integer> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, cache.getValue());
        cache.setValue((int) Math.round(eval));
    }

    @Override
    @Environment(EnvType.CLIENT)
    public List<DiagramsData> getPropertyDiagramsData(class_1799 gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        int pierce = gunData.getBulletData().getPierce();
        int modifiedValue = cacheProperty.<Integer>getCache(PierceModifier.ID);
        int pierceModifier = modifiedValue - pierce;

        double piercePercent = Math.min(pierce / 5.0, 1);
        double pierceModifierPercent = Math.min(pierceModifier / 5.0, 1);

        String titleKey = "gui.tacz.gun_refit.property_diagrams.pierce";
        String positivelyString = String.format("%d §a(+%d)", modifiedValue, pierceModifier);
        String negativelyString = String.format("%d §c(%d)", modifiedValue, pierceModifier);
        String defaultString = String.format("%d", modifiedValue);
        boolean positivelyBetter = true;

        DiagramsData diagramsData = new DiagramsData(piercePercent, pierceModifierPercent, pierceModifier, titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class PierceJsonProperty extends JsonProperty<Modifier> {
        public PierceJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier pierce = getValue();
            if (pierce != null) {
                long eval = Math.round(AttachmentPropertyManager.eval(pierce, 5));
                eval = Math.max(eval, 1);
                if (eval > 5) {
                    components.add(class_2561.method_43471("tooltip.tacz.attachment.pierce.increase").method_27692(class_124.field_1060));
                } else if (eval < 5) {
                    components.add(class_2561.method_43471("tooltip.tacz.attachment.pierce.decrease").method_27692(class_124.field_1061));
                }
            }
        }
    }

    public static class Data {
        @SerializedName("pierce")
        @Nullable
        private Modifier pierce = null;

        @Nullable
        public Modifier getPierce() {
            return pierce;
        }
    }
}