/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.extension.IEntityAdditionalSpawnData;
import cn.sh1rocu.tacz.api.extension.IEntityPersistentData;
import com.google.common.collect.Lists;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.entity.KnockBackModifier;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.api.event.common.GunDamageSourcePart;
import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.client.particle.AmmoParticleSpawner;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.init.ModDamageTypes;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import com.tacz.guns.network.message.event.ServerMessageGunKill;
import com.tacz.guns.particles.BulletHoleOption;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.AmmoSpeedModifier;
import com.tacz.guns.resource.modifier.custom.ArmorIgnoreModifier;
import com.tacz.guns.resource.modifier.custom.DamageModifier;
import com.tacz.guns.resource.modifier.custom.EffectiveRangeModifier;
import com.tacz.guns.resource.modifier.custom.ExplosionModifier;
import com.tacz.guns.resource.modifier.custom.HeadShotModifier;
import com.tacz.guns.resource.modifier.custom.IgniteModifier;
import com.tacz.guns.resource.modifier.custom.KnockbackModifier;
import com.tacz.guns.resource.modifier.custom.PierceModifier;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import com.tacz.guns.util.EntityUtil;
import com.tacz.guns.util.ExplodeUtil;
import com.tacz.guns.util.TacHitResult;
import com.tacz.guns.util.block.BlockRayTrace;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4770;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class EntityKineticBullet
extends class_1676
implements IEntityAdditionalSpawnData {
    public static final class_1299<EntityKineticBullet> TYPE = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityKineticBullet::new).disableSummon().disableSaving().fireImmune().dimensions(class_4048.method_18384((float)0.0625f, (float)0.0625f)).trackRangeChunks(5).trackedUpdateRate(5).forceTrackedVelocityUpdates(false).build();
    public static final class_6862<class_1299<?>> USE_MAGIC_DAMAGE_ON = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("tacz:use_magic_damage_on"));
    public static final class_6862<class_1299<?>> USE_VOID_DAMAGE_ON = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("tacz:use_void_damage_on"));
    public static final class_6862<class_1299<?>> PRETEND_MELEE_DAMAGE_ON = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("tacz:pretend_melee_damage_on"));
    public static final String TRACER_COLOR_OVERRIDER_KEY = "tacz:tracer_override";
    public static final String TRACER_SIZE_OVERRIDER_KEY = "tacz:tracer_size";
    private class_2960 ammoId = DefaultAssets.EMPTY_AMMO_ID;
    private int life = 200;
    private float speed = 1.0f;
    private float gravity = 0.0f;
    private float friction = 0.01f;
    private LinkedList<ExtraDamage.DistanceDamagePair> damageAmount = Lists.newLinkedList();
    private float distanceAmount = 0.0f;
    private float knockback = 0.0f;
    private boolean explosion = false;
    private boolean igniteEntity = false;
    private boolean igniteBlock = false;
    private int igniteEntityTime = 2;
    private float explosionDamage = 3.0f;
    private float explosionRadius = 3.0f;
    private int explosionDelayCount = Integer.MAX_VALUE;
    private boolean explosionKnockback = false;
    private boolean explosionDestroyBlock = false;
    private float damageModifier = 1.0f;
    private int pierce = 1;
    private class_243 startPos;
    private boolean isTracerAmmo;
    private float cameraXRot;
    private float cameraYRot;
    private Vector3f firstPersonRenderOffset;
    private class_2960 gunId;
    private class_2960 gunDisplayId;
    private float armorIgnore;
    private float headShot;

    public EntityKineticBullet(class_1299<? extends class_1676> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public EntityKineticBullet(class_1299<? extends class_1676> type, double x, double y, double z, class_1937 worldIn) {
        this(type, worldIn);
        this.method_5814(x, y, z);
    }

    public EntityKineticBullet(class_1937 worldIn, class_1309 throwerIn, class_1799 gunItem, class_2960 ammoId, class_2960 gunId, class_2960 gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, gunDisplayId, isTracerAmmo, gunData, bulletData);
    }

    public EntityKineticBullet(class_1937 worldIn, class_1309 throwerIn, class_1799 gunItem, class_2960 ammoId, class_2960 gunId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID, isTracerAmmo, gunData, bulletData);
    }

    protected EntityKineticBullet(class_1299<? extends class_1676> type, class_1937 worldIn, class_1309 throwerIn, class_1799 gunItem, class_2960 ammoId, class_2960 gunId, class_2960 gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(type, throwerIn.method_23317(), throwerIn.method_23320() - (double)0.1f, throwerIn.method_23321(), worldIn);
        this.method_7432((class_1297)throwerIn);
        AttachmentCacheProperty cacheProperty = Objects.requireNonNull(IGunOperator.fromLivingEntity(throwerIn).getCacheProperty());
        this.armorIgnore = class_3532.method_15363((float)((Float)cacheProperty.getCache(ArmorIgnoreModifier.ID)).floatValue(), (float)0.0f, (float)1.0f);
        this.headShot = Math.max(((Float)cacheProperty.getCache(HeadShotModifier.ID)).floatValue(), 0.0f);
        this.knockback = Math.max(((Float)cacheProperty.getCache(KnockbackModifier.ID)).floatValue(), 0.0f);
        this.ammoId = ammoId;
        this.life = class_3532.method_15340((int)((int)(bulletData.getLifeSecond() * 20.0f)), (int)1, (int)Integer.MAX_VALUE);
        this.speed = class_3532.method_15363((float)(((Float)cacheProperty.getCache(AmmoSpeedModifier.ID)).floatValue() / 20.0f), (float)0.0f, (float)30.0f);
        this.gravity = class_3532.method_15363((float)bulletData.getGravity(), (float)0.0f, (float)Float.MAX_VALUE);
        this.friction = class_3532.method_15363((float)bulletData.getFriction(), (float)0.0f, (float)Float.MAX_VALUE);
        Ignite ignite = (Ignite)cacheProperty.getCache(IgniteModifier.ID);
        this.igniteEntity = bulletData.getIgnite().isIgniteEntity() || ignite.isIgniteEntity();
        this.igniteEntityTime = Math.max(bulletData.getIgniteEntityTime(), 0);
        this.igniteBlock = bulletData.getIgnite().isIgniteBlock() || ignite.isIgniteBlock();
        this.damageAmount = (LinkedList)cacheProperty.getCache(DamageModifier.ID);
        this.distanceAmount = ((Float)cacheProperty.getCache(EffectiveRangeModifier.ID)).floatValue();
        if (bulletData.getBulletAmount() > 1) {
            this.damageModifier = 1.0f / (float)bulletData.getBulletAmount();
        }
        this.pierce = class_3532.method_15340((int)((Integer)cacheProperty.getCache(PierceModifier.ID)), (int)1, (int)Integer.MAX_VALUE);
        ExplosionData explosionData = (ExplosionData)cacheProperty.getCache(ExplosionModifier.ID);
        if (explosionData != null) {
            this.explosion = explosionData.isExplode();
            this.explosionDamage = (float)class_3532.method_15350((double)((double)explosionData.getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)3.4028234663852886E38);
            this.explosionRadius = class_3532.method_15363((float)explosionData.getRadius(), (float)0.0f, (float)Float.MAX_VALUE);
            this.explosionKnockback = explosionData.isKnockback();
            int delayTickCount = (int)(explosionData.getDelay() * 20.0f);
            if (delayTickCount < 0) {
                delayTickCount = Integer.MAX_VALUE;
            }
            this.explosionDestroyBlock = explosionData.isDestroyBlock() && (Boolean)AmmoConfig.EXPLOSIVE_AMMO_DESTROYS_BLOCK.get() != false;
            this.explosionDelayCount = Math.max(delayTickCount, 1);
        }
        double posX = throwerIn.field_6038 + (throwerIn.method_23317() - throwerIn.field_6038) / 2.0;
        double posY = throwerIn.field_5971 + (throwerIn.method_23318() - throwerIn.field_5971) / 2.0 + (double)throwerIn.method_5751();
        double posZ = throwerIn.field_5989 + (throwerIn.method_23321() - throwerIn.field_5989) / 2.0;
        this.method_5814(posX, posY, posZ);
        this.startPos = this.method_19538();
        this.isTracerAmmo = isTracerAmmo;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    protected void method_5693() {
    }

    public void method_5773() {
        super.method_5773();
        this.onBulletTick();
        if (this.method_37908().field_9236) {
            AmmoParticleSpawner.addParticle(this);
        }
        class_243 movement = this.method_18798();
        double x = movement.field_1352;
        double y = movement.field_1351;
        double z = movement.field_1350;
        double distance = movement.method_37267();
        this.method_36456((float)Math.toDegrees(class_3532.method_15349((double)x, (double)z)));
        this.method_36457((float)Math.toDegrees(class_3532.method_15349((double)y, (double)distance)));
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        this.method_36457(EntityKineticBullet.method_26960((float)this.field_6004, (float)this.method_36455()));
        this.method_36456(EntityKineticBullet.method_26960((float)this.field_5982, (float)this.method_36454()));
        double nextPosX = this.method_23317() + x;
        double nextPosY = this.method_23318() + y;
        double nextPosZ = this.method_23321() + z;
        this.method_5814(nextPosX, nextPosY, nextPosZ);
        float friction = this.friction;
        float gravity = this.gravity;
        if (this.method_5799()) {
            for (int i = 0; i < 4; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11247, nextPosX - x * 0.25, nextPosY - y * 0.25, nextPosZ - z * 0.25, x, y, z);
            }
            friction = 0.4f;
            gravity *= 0.6f;
        }
        this.method_18799(this.method_18798().method_1021((double)(1.0f - friction)));
        this.method_18799(this.method_18798().method_1031(0.0, (double)(-gravity), 0.0));
        if (this.field_6012 >= this.life - 1) {
            this.method_31472();
        }
    }

    protected void onBulletTick() {
        if (!this.method_37908().method_8608()) {
            if (this.explosion) {
                if (this.explosionDelayCount > 0) {
                    --this.explosionDelayCount;
                } else {
                    ExplodeUtil.createExplosion(this.method_24921(), (class_1297)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, this.method_19538());
                    this.method_31472();
                    return;
                }
            }
            class_243 startVec = this.method_19538();
            class_243 endVec = startVec.method_1019(this.method_18798());
            Object result = BlockRayTrace.rayTraceBlocks(this.method_37908(), new class_3959(startVec, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            class_3965 resultB = result;
            if (resultB.method_17783() != class_239.class_240.field_1333) {
                endVec = resultB.method_17784();
            }
            List<EntityResult> hitEntities = null;
            if (this.pierce <= 1 || this.explosion) {
                EntityResult entityResult = EntityUtil.findEntityOnPath(this, startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = EntityUtil.findEntitiesOnPath(this, startVec, endVec);
            }
            if (hitEntities != null && !hitEntities.isEmpty()) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                for (int i = 0; (i < this.pierce || i < 1) && i < hitEntityResult.length - 1; ++i) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; ++j) {
                        if (!(hitEntityResult[j].hitVec.method_1022(startVec) < hitEntityResult[k].hitVec.method_1022(startVec))) continue;
                        k = j;
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new TacHitResult(entityResult);
                    this.onHitEntity((TacHitResult)((Object)result), startVec, endVec);
                    --this.pierce;
                    if (this.pierce >= 1 && !this.explosion) continue;
                    this.method_31472();
                    return;
                }
            }
            this.onHitBlock(resultB, startVec, endVec);
        }
    }

    public void shoot(double pitch, double yaw, float pVelocity, Vector2d vector2d) {
        Vector3d left = new Vector3d(vector2d.x, vector2d.y, 8.0);
        left.rotateX(pitch * 0.01745329238474369);
        left.rotateY(-yaw * 0.01745329238474369);
        class_243 vec3 = new class_243(left.x, left.y, left.z).method_1029().method_1021((double)pVelocity);
        this.method_18800(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        double d0 = vec3.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vec3.field_1351, (double)d0) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void shootFromRotation(class_1297 pShooter, float pX, float pY, float pZ, float pVelocity, Vector2d vector2d) {
        this.shoot(pX, pY, pVelocity, vector2d);
        class_243 vec3 = pShooter.method_18798();
        this.method_18799(this.method_18798().method_1031(vec3.field_1352, pShooter.method_24828() ? 0.0 : vec3.field_1351, vec3.field_1350));
    }

    protected void onHitEntity(TacHitResult result, class_243 startVec, class_243 endVec) {
        KnockBackModifier modifier;
        class_1309 livingCore;
        class_1297 class_12972;
        class_1297 class_12973 = result.method_17782();
        if (class_12973 instanceof ITargetEntity) {
            ITargetEntity targetEntity = (ITargetEntity)class_12973;
            class_1282 source = this.method_48923().method_48811((class_1297)this, this.method_24921());
            targetEntity.onProjectileHit((class_1297)this, result, source, this.getDamage(result.method_17784()));
            return;
        }
        class_1297 entity = result.method_17782();
        @Nullable class_1297 owner = this.method_24921();
        class_1309 attacker = owner instanceof class_1309 ? (class_1309)owner : null;
        Pair sources = this.createDamageSources(MaybeMultipartEntity.of(entity));
        boolean headshot = result.isHeadshot();
        float damage = this.getDamage(result.method_17784());
        float headShotMultiplier = Math.max(this.headShot, 0.0f);
        EntityHurtByGunEvent.Pre preEvent = new EntityHurtByGunEvent.Pre((class_1297)this, entity, attacker, this.gunId, this.gunDisplayId, damage, sources, headshot, headShotMultiplier, LogicalSide.SERVER);
        ((EntityHurtByGunEvent.PreCallBack)EntityHurtByGunEvent.PRE.invoker()).post(preEvent);
        if (preEvent.isCanceled()) {
            return;
        }
        entity = preEvent.getHurtEntity();
        MaybeMultipartEntity parts = MaybeMultipartEntity.of(entity);
        attacker = preEvent.getAttacker();
        class_2960 newGunId = preEvent.getGunId();
        damage = preEvent.getBaseAmount();
        sources = Pair.of((Object)preEvent.getDamageSource(GunDamageSourcePart.NON_ARMOR_PIERCING), (Object)preEvent.getDamageSource(GunDamageSourcePart.ARMOR_PIERCING));
        headshot = preEvent.isHeadShot();
        headShotMultiplier = preEvent.getHeadshotMultiplier();
        if (entity == null) {
            return;
        }
        if (this.igniteEntity && ((Boolean)AmmoConfig.IGNITE_ENTITY.get()).booleanValue()) {
            entity.method_5639(this.igniteEntityTime);
            class_12972 = this.method_37908();
            if (class_12972 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_12972;
                serverLevel.method_14199((class_2394)class_2398.field_11239, entity.method_23317(), entity.method_23318() + (double)entity.method_5751(), entity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (headshot) {
            damage *= headShotMultiplier;
        }
        if ((class_12972 = parts.core()) instanceof class_1309) {
            livingCore = (class_1309)class_12972;
            modifier = KnockBackModifier.fromLivingEntity(livingCore);
            modifier.setKnockBackStrength(this.knockback);
            this.tacAttackEntity(parts, damage, (Pair<class_1282, class_1282>)sources);
            modifier.resetKnockBackStrength();
        } else {
            this.tacAttackEntity(parts, damage, (Pair<class_1282, class_1282>)sources);
        }
        if (this.explosion) {
            parts.core().field_6008 = 0;
            ExplodeUtil.createExplosion(this.method_24921(), (class_1297)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, result.method_17784());
        }
        if ((modifier = parts.core()) instanceof class_1309) {
            livingCore = (class_1309)modifier;
            if (!this.method_37908().field_9236) {
                int attackerId;
                int n = attackerId = attacker == null ? 0 : attacker.method_5628();
                if (livingCore.method_29504()) {
                    EntityKillByGunEvent killByGunEvent = new EntityKillByGunEvent((class_1297)this, livingCore, attacker, newGunId, this.gunDisplayId, damage, (Pair<class_1282, class_1282>)sources, headshot, headShotMultiplier, LogicalSide.SERVER);
                    ((EntityKillByGunEvent.Callback)EntityKillByGunEvent.CALLBACK.invoker()).post(killByGunEvent);
                    NetworkHandler.sendToDimension(new ServerMessageGunKill(this.method_5628(), livingCore.method_5628(), attackerId, newGunId, this.gunDisplayId, damage, headshot, headShotMultiplier), (class_1297)livingCore);
                } else {
                    EntityHurtByGunEvent.Post hurtByGunEvent = new EntityHurtByGunEvent.Post((class_1297)this, (class_1297)livingCore, attacker, newGunId, this.gunDisplayId, damage, (Pair<class_1282, class_1282>)sources, headshot, headShotMultiplier, LogicalSide.SERVER);
                    ((EntityHurtByGunEvent.PostCallBack)EntityHurtByGunEvent.POST.invoker()).post(hurtByGunEvent);
                    NetworkHandler.sendToDimension(new ServerMessageGunHurt(this.method_5628(), livingCore.method_5628(), attackerId, newGunId, this.gunDisplayId, damage, headshot, headShotMultiplier), (class_1297)livingCore);
                }
            }
        }
    }

    protected void onHitBlock(class_3965 result, class_243 startVec, class_243 endVec) {
        if (result.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_2338 pos = result.method_17777();
        class_243 hitVec = result.method_17784();
        AmmoHitBlockEvent ammoHitBlockEvent = new AmmoHitBlockEvent(this.method_37908(), result, this.method_37908().method_8320(pos), this);
        ((AmmoHitBlockEvent.Callback)AmmoHitBlockEvent.CALLBACK.invoker()).post(ammoHitBlockEvent);
        if (ammoHitBlockEvent.isCanceled()) {
            return;
        }
        super.method_24920(result);
        if (this.explosion) {
            ExplodeUtil.createExplosion(this.method_24921(), (class_1297)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, hitVec);
            this.method_31472();
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            BulletHoleOption bulletHoleOption = new BulletHoleOption(result.method_17780(), result.method_17777(), this.ammoId.toString(), this.gunId.toString(), this.gunDisplayId.toString());
            serverLevel.method_14199((class_2394)bulletHoleOption, hitVec.field_1352, hitVec.field_1351, hitVec.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if (this.igniteBlock) {
                serverLevel.method_14199((class_2394)class_2398.field_11239, hitVec.field_1352, hitVec.field_1351, hitVec.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.igniteBlock && ((Boolean)AmmoConfig.IGNITE_BLOCK.get()).booleanValue()) {
            class_2338 offsetPos = pos.method_10093(result.method_17780());
            if (class_4770.method_30032((class_1937)this.method_37908(), (class_2338)offsetPos, (class_2350)result.method_17780())) {
                class_2680 fireState = class_4770.method_24416((class_1922)this.method_37908(), (class_2338)offsetPos);
                this.method_37908().method_8652(offsetPos, fireState, 11);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11239, hitVec.field_1352 - 1.0 + this.field_5974.method_43058() * 2.0, hitVec.field_1351, hitVec.field_1350 - 1.0 + this.field_5974.method_43058() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.method_31472();
    }

    public float getDamage(class_243 hitVec) {
        double playerDistance = hitVec.method_1022(this.startPos);
        for (ExtraDamage.DistanceDamagePair pair : this.damageAmount) {
            float f = this.damageAmount.get(0).getDistance() == pair.getDistance() ? this.distanceAmount : pair.getDistance();
            float effectiveDistance = f;
            if (!(playerDistance < (double)effectiveDistance)) continue;
            float damage = pair.getDamage();
            return Math.max(damage * this.damageModifier, 0.0f);
        }
        return 0.0f;
    }

    private Pair<class_1282, class_1282> createDamageSources(MaybeMultipartEntity parts) {
        class_1282 source1;
        class_1282 source2;
        EntityKineticBullet directCause;
        class_1299 hitPartType = parts.hitPart().method_5864();
        EntityKineticBullet entityKineticBullet = directCause = hitPartType.method_20210(PRETEND_MELEE_DAMAGE_ON) ? this.method_24921() : this;
        if (hitPartType.method_20210(USE_MAGIC_DAMAGE_ON)) {
            source1 = source2 = this.method_48923().method_48815((class_1297)this, this.method_24921());
        } else if (hitPartType.method_20210(USE_VOID_DAMAGE_ON)) {
            source1 = ModDamageTypes.Sources.bulletVoid(this.method_37908().method_30349(), (class_1297)directCause, this.method_24921(), false);
            source2 = ModDamageTypes.Sources.bulletVoid(this.method_37908().method_30349(), (class_1297)directCause, this.method_24921(), true);
        } else {
            source1 = ModDamageTypes.Sources.bullet(this.method_37908().method_30349(), (class_1297)directCause, this.method_24921(), false);
            source2 = ModDamageTypes.Sources.bullet(this.method_37908().method_30349(), (class_1297)directCause, this.method_24921(), true);
        }
        return Pair.of((Object)source1, (Object)source2);
    }

    private void tacAttackEntity(MaybeMultipartEntity parts, float damage, Pair<class_1282, class_1282> sources) {
        class_1282 source1 = (class_1282)sources.getLeft();
        class_1282 source2 = (class_1282)sources.getRight();
        float armorDamagePercent = class_3532.method_15363((float)this.armorIgnore, (float)0.0f, (float)1.0f);
        float normalDamagePercent = 1.0f - armorDamagePercent;
        parts.core().field_6008 = 0;
        parts.hitPart().method_5643(source1, damage * normalDamagePercent);
        parts.core().field_6008 = 0;
        parts.hitPart().method_5643(source2, damage * armorDamagePercent);
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return IEntityAdditionalSpawnData.getEntitySpawningPacket((class_1297)this);
    }

    @Override
    public void writeSpawnData(class_2540 buffer) {
        buffer.writeFloat(this.method_36455());
        buffer.writeFloat(this.method_36454());
        buffer.writeDouble(this.method_18798().field_1352);
        buffer.writeDouble(this.method_18798().field_1351);
        buffer.writeDouble(this.method_18798().field_1350);
        class_1297 entity = this.method_24921();
        buffer.writeInt(entity != null ? entity.method_5628() : 0);
        buffer.method_10812(this.ammoId);
        buffer.writeFloat(this.gravity);
        buffer.writeBoolean(this.explosion);
        buffer.writeBoolean(this.igniteEntity);
        buffer.writeBoolean(this.igniteBlock);
        buffer.writeFloat(this.explosionRadius);
        buffer.writeFloat(this.explosionDamage);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.friction);
        buffer.writeInt(this.pierce);
        buffer.writeBoolean(this.isTracerAmmo);
        buffer.method_10812(this.gunId);
        buffer.method_10812(this.gunDisplayId);
    }

    @Override
    public void readSpawnData(class_2540 additionalData) {
        this.method_36457(additionalData.readFloat());
        this.method_36456(additionalData.readFloat());
        this.method_18800(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        class_1297 entity = this.method_37908().method_8469(additionalData.readInt());
        if (entity != null) {
            this.method_7432(entity);
        }
        this.ammoId = additionalData.method_10810();
        this.gravity = additionalData.readFloat();
        this.explosion = additionalData.readBoolean();
        this.igniteEntity = additionalData.readBoolean();
        this.igniteBlock = additionalData.readBoolean();
        this.explosionRadius = additionalData.readFloat();
        this.explosionDamage = additionalData.readFloat();
        this.life = additionalData.readInt();
        this.speed = additionalData.readFloat();
        this.friction = additionalData.readFloat();
        this.pierce = additionalData.readInt();
        this.isTracerAmmo = additionalData.readBoolean();
        this.gunId = additionalData.method_10810();
        this.gunDisplayId = additionalData.method_10810();
    }

    public class_2960 getAmmoId() {
        return this.ammoId;
    }

    public class_2960 getGunId() {
        return this.gunId;
    }

    public class_2960 getGunDisplayId() {
        return this.gunDisplayId;
    }

    public boolean isTracerAmmo() {
        return this.isTracerAmmo;
    }

    public class_5819 getRandom() {
        return this.field_5974;
    }

    public float getCameraYRot() {
        return this.cameraYRot;
    }

    public void setCameraYRot(float cameraYRot) {
        this.cameraYRot = cameraYRot;
    }

    public float getCameraXRot() {
        return this.cameraXRot;
    }

    public void setCameraXRot(float cameraXRot) {
        this.cameraXRot = cameraXRot;
    }

    public Vector3f getFirstPersonRenderOffset() {
        return this.firstPersonRenderOffset;
    }

    public void setFirstPersonRenderOffset(Vector3f originRenderOffset) {
        this.firstPersonRenderOffset = originRenderOffset;
    }

    public Optional<float[]> getTracerColorOverride() {
        class_2487 pd = ((IEntityPersistentData)((Object)this)).tacz$getPersistentData();
        if (!pd.method_10573(TRACER_COLOR_OVERRIDER_KEY, 11)) {
            return Optional.empty();
        }
        int[] ints = pd.method_10561(TRACER_COLOR_OVERRIDER_KEY);
        switch (ints.length) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                float albedo = (float)ints[0] / 255.0f;
                return Optional.of(new float[]{albedo, albedo, albedo, 1.0f});
            }
            case 2: {
                float albedo = (float)ints[0] / 255.0f;
                float alpha = (float)ints[1] / 255.0f;
                return Optional.of(new float[]{albedo, albedo, albedo, alpha});
            }
            case 3: {
                float r = (float)ints[0] / 255.0f;
                float g = (float)ints[1] / 255.0f;
                float b = (float)ints[2] / 255.0f;
                return Optional.of(new float[]{r, g, b, 1.0f});
            }
        }
        float r = (float)ints[0] / 255.0f;
        float g = (float)ints[1] / 255.0f;
        float b = (float)ints[2] / 255.0f;
        float a = (float)ints[3] / 255.0f;
        return Optional.of(new float[]{r, g, b, a});
    }

    public float getTracerSizeOverride() {
        class_2487 pd = ((IEntityPersistentData)((Object)this)).tacz$getPersistentData();
        return pd.method_10573(TRACER_SIZE_OVERRIDER_KEY, 99) ? pd.method_10583(TRACER_SIZE_OVERRIDER_KEY) : 1.0f;
    }

    public boolean method_34714(@Nullable class_1297 entity) {
        if (entity == null) {
            return false;
        }
        return super.method_34714(entity);
    }

    public static class EntityResult {
        private final class_1297 entity;
        private final class_243 hitVec;
        private final boolean headshot;

        public EntityResult(class_1297 entity, class_243 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        public class_243 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }

    public record MaybeMultipartEntity(class_1297 hitPart, class_1297 core) {
        public static MaybeMultipartEntity of(class_1297 hitPart) {
            class_1297 core = hitPart;
            return new MaybeMultipartEntity(hitPart, core);
        }
    }
}

