package cn.sh1rocu.tacz.util.itemhandler;

import cn.sh1rocu.tacz.util.itemhandler.IItemHandler;
import cn.sh1rocu.tacz.util.itemhandler.IItemHandlerModifiable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class SlotItemHandler extends class_1735 {
    private static class_1263 emptyInventory = new class_1277(0);
    private final IItemHandler itemHandler;
    protected final int index;

    public SlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.itemHandler = itemHandler;
        this.field_7874 = index;
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        if (stack.method_7960())
            return false;
        return itemHandler.isItemValid(field_7874, stack);
    }

    @Override
    public class_1799 method_7677() {
        return this.getItemHandler().getStackInSlot(field_7874);
    }

    // Override if your IItemHandler does not implement IItemHandlerModifiable
    @Override
    public void method_7673(class_1799 stack) {
        ((IItemHandlerModifiable) this.getItemHandler()).setStackInSlot(field_7874, stack);
        this.method_7668();
    }

    // Override if your IItemHandler does not implement IItemHandlerModifiable
    // @Override
    public void initialize(class_1799 stack) {
        ((IItemHandlerModifiable) this.getItemHandler()).setStackInSlot(field_7874, stack);
        this.method_7668();
    }

    @Override
    public void method_7670(class_1799 oldStackIn, class_1799 newStackIn) {
    }

    @Override
    public int method_7675() {
        return this.itemHandler.getSlotLimit(this.field_7874);
    }

    @Override
    public int method_7676(class_1799 stack) {
        return Math.min(stack.method_7914(), this.itemHandler.getSlotLimit(this.field_7874));
    }

    @Override
    public boolean method_7674(class_1657 playerIn) {
        return !this.getItemHandler().extractItem(field_7874, 1, true).method_7960();
    }

    @Override
    public class_1799 method_7671(int amount) {
        return this.getItemHandler().extractItem(field_7874, amount, false);
    }

    public IItemHandler getItemHandler() {
        return itemHandler;
    }
/* TODO Slot patches
@Override
public boolean isSameInventory(Slot other)
{
return other instanceof SlotItemHandler && ((SlotItemHandler) other).getItemHandler() == this.itemHandler;
}*/
}
