package com.tacz.guns.api.item;

import com.tacz.guns.api.item.attachment.AttachmentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public interface IAttachment {
    /**
     * @return 如果物品类型为 IAttachment 则返回显式转换后的实例，否则返回 null。
     */
    @Nullable
    static IAttachment getIAttachmentOrNull(@Nullable class_1799 stack) {
        if (stack == null) {
            return null;
        }
        if (stack.method_7909() instanceof IAttachment iAttachment) {
            return iAttachment;
        }
        return null;
    }

    /**
     * 获取配件 ID
     */
    @Nonnull
    class_2960 getAttachmentId(class_1799 attachmentStack);

    /**
     * 设置配件 ID
     */
    void setAttachmentId(class_1799 attachmentStack, @Nullable class_2960 attachmentId);

    /**@deprecated
     */
    @Deprecated
    @Nullable
    class_2960 getSkinId(class_1799 attachmentStack);

    /**@deprecated
     */
    @Deprecated
    void setSkinId(class_1799 attachmentStack, @Nullable class_2960 skinId);

    /**
     * 获取瞄具配件的缩放倍率的数字索引，仅瞄具配件可用
     */
    int getZoomNumber(class_1799 attachmentStack);

    /**
     * 设置瞄具配件的缩放倍率的数字索引
     */
    void setZoomNumber(class_1799 attachmentStack, int zoomNumber);

    /**
     * 配件类型
     */
    @Nonnull
    AttachmentType getType(class_1799 attachmentStack);

    boolean hasCustomLaserColor(class_1799 attachmentStack);

    /**
     * 获取镭射配件的激光颜色
     * @return 镭射颜色，RGB
     */
    int getLaserColor(class_1799 attachmentStack);

    void setLaserColor(class_1799 attachmentStack, int color);
}
