package com.tacz.guns.block.entity;

import com.tacz.guns.init.ModBlocks;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

import static com.tacz.guns.block.StatueBlock.FACING;

public class StatueBlockEntity extends class_2586 {
    public static final class_2591<StatueBlockEntity> TYPE = class_2591.class_2592.method_20528(StatueBlockEntity::new, ModBlocks.STATUE).method_11034(null);
    private static final String ITEM_TAG = "Item";
    private class_1799 gunItem = class_1799.field_8037;

    public StatueBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(TYPE, pPos, pBlockState);
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 state, StatueBlockEntity statueBlockEntity) {
        if (level.method_8510() % 100 == 0 && !statueBlockEntity.gunItem.method_7960()) {
            class_2350 direction = state.method_11654(FACING);

            double x = blockPos.method_10263() + direction.method_10148() * 0.75 + 0.5;
            double z = blockPos.method_10260() + direction.method_10165() * 0.75 + 0.5;

            double dx = -0.02 + level.field_9229.method_43058() * 0.04;
            double dz = -0.02 + level.field_9229.method_43058() * 0.04;
            double dy = -0.02 + level.field_9229.method_43058() * 0.04;

            level.method_8406(class_2398.field_11207, x, blockPos.method_10264() + 2.25, z, dx, dy, dz);
        }
    }

    public class_1799 getGunItem() {
        return gunItem;
    }

    public void setGun(class_1799 stack) {
        this.dropItem();
        this.gunItem = stack.method_7972();
        if (field_11863 != null) {
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
        }
        this.method_5431();
    }

    public void dropItem() {
        if (!gunItem.method_7960() && field_11863 != null) {
            class_2350 direction = method_11010().method_11654(FACING);
            class_2248.method_9577(field_11863, field_11867.method_10093(direction).method_10084(), gunItem);
            this.gunItem = class_1799.field_8037;
            if (field_11863 != null) {
                class_2680 state = field_11863.method_8320(field_11867);
                field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
            }
            this.method_5431();
        }
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573(ITEM_TAG, class_2520.field_33260)) {
            this.gunItem = class_1799.method_57359(provider, tag.method_10562(ITEM_TAG));
        }
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(ITEM_TAG, gunItem.method_57375(provider));
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        tag.method_10566(ITEM_TAG, gunItem.method_57375(provider));
        return tag;
    }

    // TODO
//    @Override
//    public AABB getRenderBoundingBox() {
//        return AABB.encapsulatingFullBlocks(worldPosition.offset(-2, 0, -2), worldPosition.offset(2, 2, 2));
//    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }
}
